/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.mining.model.segmentation;

import java.util.Collections;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kie.pmml.models.mining.model.AbstractKiePMMLMiningModelTest;
import org.kie.pmml.models.mining.model.enums.MULTIPLE_MODEL_METHOD;
import org.kie.pmml.models.mining.model.segmentation.KiePMMLSegment;
import org.kie.pmml.models.mining.model.segmentation.KiePMMLSegmentation;

public class KiePMMLSegmentationTest {
    private static final String SEGMENTATION_NAME = "SEGMENTATION_NAME";
    private static final MULTIPLE_MODEL_METHOD MULTIPLE_MODELMETHOD = MULTIPLE_MODEL_METHOD.MAJORITY_VOTE;
    private static KiePMMLSegmentation.Builder BUILDER;
    private static KiePMMLSegmentation KIE_PMML_SEGMENTATION;

    @BeforeClass
    public static void setup() {
        BUILDER = KiePMMLSegmentation.builder((String)SEGMENTATION_NAME, Collections.emptyList(), (MULTIPLE_MODEL_METHOD)MULTIPLE_MODELMETHOD);
        Assertions.assertThat((Object)BUILDER).isNotNull();
        KIE_PMML_SEGMENTATION = (KiePMMLSegmentation)BUILDER.build();
        Assertions.assertThat((Object)KIE_PMML_SEGMENTATION).isNotNull();
    }

    @Test
    public void getMultipleModelMethod() {
        Assertions.assertThat((Comparable)KIE_PMML_SEGMENTATION.getMultipleModelMethod()).isEqualTo((Object)MULTIPLE_MODELMETHOD);
    }

    @Test
    public void getSegments() {
        Assertions.assertThat((List)KIE_PMML_SEGMENTATION.getSegments()).isNull();
        List<KiePMMLSegment> segments = AbstractKiePMMLMiningModelTest.getKiePMMLSegments();
        KIE_PMML_SEGMENTATION = (KiePMMLSegmentation)BUILDER.withSegments(segments).build();
        Assertions.assertThat((List)KIE_PMML_SEGMENTATION.getSegments()).isEqualTo(segments);
    }
}

