/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.mining.model.enums;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalDouble;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import java.util.stream.Stream;
import org.kie.pmml.api.exceptions.KieEnumException;
import org.kie.pmml.commons.model.tuples.KiePMMLNameValue;
import org.kie.pmml.commons.model.tuples.KiePMMLValueWeight;

public class MultipleModelMethodFunctions {
    public static final Function<LinkedHashMap<String, KiePMMLNameValue>, Object> MOST_FREQUENT_RESULT = inputData -> {
        Map groupedValues = MultipleModelMethodFunctions.objectStream(inputData.values().stream()).collect(Collectors.groupingBy(Function.identity(), Collectors.counting())).entrySet().stream().sorted(Map.Entry.comparingByValue().reversed()).collect(Collectors.toMap(entry -> {
            Object key = entry.getKey();
            if (key instanceof KiePMMLValueWeight) {
                return ((KiePMMLValueWeight)key).getValue();
            }
            return key;
        }, Map.Entry::getValue, (a, b) -> {
            throw new AssertionError();
        }, LinkedHashMap::new));
        Object toReturn = groupedValues.entrySet().iterator().next().getKey();
        if (toReturn == null) {
            throw new KieEnumException("Failed to retrieve MAJORITY_VOTE");
        }
        return toReturn;
    };
    public static final Function<LinkedHashMap<String, KiePMMLNameValue>, Object> AVERAGE_RESULT = inputData -> MultipleModelMethodFunctions.doubleStream(inputData.values().stream(), "AVERAGE").average().orElseThrow(() -> new KieEnumException("Failed to get AVERAGE"));
    public static final Function<LinkedHashMap<String, KiePMMLNameValue>, Object> WEIGHTED_AVERAGE_RESULT = inputData -> {
        AtomicReference<Double> weightedSum = new AtomicReference<Double>(0.0);
        AtomicReference<Double> weights = new AtomicReference<Double>(0.0);
        MultipleModelMethodFunctions.valueWeightStream(inputData.values().stream(), "WEIGHTED_AVERAGE").forEach(elem -> {
            weightedSum.accumulateAndGet(elem.weightedValue(), Double::sum);
            weights.accumulateAndGet(elem.getWeight(), Double::sum);
        });
        return weightedSum.get() / weights.get();
    };
    public static final Function<LinkedHashMap<String, KiePMMLNameValue>, Object> MEDIAN_RESULT = inputData -> {
        DoubleStream sortedValues = MultipleModelMethodFunctions.doubleStream(inputData.values().stream(), "MEDIAN").sorted();
        OptionalDouble toReturn = inputData.size() % 2 == 0 ? sortedValues.skip((long)(inputData.size() / 2) - 1L).limit(2L).average() : sortedValues.skip(inputData.size() / 2).findFirst();
        return toReturn.orElseThrow(() -> new KieEnumException("Failed to get MEDIAN"));
    };
    public static final Function<LinkedHashMap<String, KiePMMLNameValue>, Object> WEIGHTED_MEDIAN_RESULT = inputData -> {
        List kiePMMLValueWeights = MultipleModelMethodFunctions.valueWeightStream(inputData.values().stream(), "WEIGHTED_MEDIAN").sorted((o1, o2) -> {
            int toReturn = 0;
            if (o1.getValue() > o2.getValue()) {
                toReturn = 1;
            } else if (o1.getValue() < o2.getValue()) {
                toReturn = -1;
            }
            return toReturn;
        }).collect(Collectors.toList());
        double weightsSum = kiePMMLValueWeights.stream().map(KiePMMLValueWeight::getWeight).reduce(Double::sum).orElseThrow(() -> new KieEnumException("Failed to get WEIGHTED_MEDIAN"));
        double weightsMedian = weightsSum / 2.0;
        double weightedMedianSum = 0.0;
        for (KiePMMLValueWeight kiePMMLValueWeight : kiePMMLValueWeights) {
            if (!((weightedMedianSum += kiePMMLValueWeight.getWeight()) > weightsMedian)) continue;
            return kiePMMLValueWeight.getValue();
        }
        throw new KieEnumException("Failed to get WEIGHTED_MEDIAN");
    };
    public static final Function<LinkedHashMap<String, KiePMMLNameValue>, Object> MAX_RESULT = inputData -> MultipleModelMethodFunctions.doubleStream(inputData.values().stream(), "MAX").max().orElseThrow(() -> new KieEnumException("Failed to get MAX"));
    public static final Function<LinkedHashMap<String, KiePMMLNameValue>, Object> SUM_RESULT = inputData -> MultipleModelMethodFunctions.doubleStream(inputData.values().stream(), "SUM").sum();
    public static final Function<LinkedHashMap<String, KiePMMLNameValue>, Object> WEIGHTED_SUM_RESULT = inputData -> MultipleModelMethodFunctions.valueWeightStream(inputData.values().stream(), "WEIGHTED_SUM").mapToDouble(KiePMMLValueWeight::weightedValue).sum();
    public static final Function<LinkedHashMap<String, KiePMMLNameValue>, Object> SELECT_FIRST_RESULT = inputData -> {
        if (inputData.entrySet().iterator().hasNext()) {
            Object toReturn = ((KiePMMLNameValue)inputData.entrySet().iterator().next().getValue()).getValue();
            if (toReturn instanceof KiePMMLValueWeight) {
                toReturn = ((KiePMMLValueWeight)toReturn).getValue();
            }
            return toReturn;
        }
        throw new KieEnumException("Failed to SELECT_FIRST");
    };
    public static final Function<LinkedHashMap<String, KiePMMLNameValue>, Object> SELECT_ALL_RESULT = inputData -> MultipleModelMethodFunctions.objectStream(inputData.values().stream()).filter(Objects::nonNull).map(value -> {
        if (value instanceof KiePMMLValueWeight) {
            return ((KiePMMLValueWeight)value).getValue();
        }
        return value;
    }).collect(Collectors.toList());
    public static final Function<LinkedHashMap<String, KiePMMLNameValue>, Object> SELECT_LAST_RESULT = inputData -> {
        Iterator iterator = inputData.entrySet().iterator();
        Object toReturn = null;
        while (iterator.hasNext()) {
            toReturn = iterator.next().getValue();
        }
        if (toReturn != null) {
            if (toReturn instanceof KiePMMLValueWeight) {
                return ((KiePMMLValueWeight)toReturn).getValue();
            }
            return ((KiePMMLNameValue)toReturn).getValue();
        }
        throw new KieEnumException("Failed to MODEL_CHAIN");
    };
    public static final Function<LinkedHashMap<String, List<KiePMMLNameValue>>, LinkedHashMap<String, Double>> PROBABILITY_FUNCTION = inputData -> {
        Map<String, List<KiePMMLNameValue>> mappedValues = inputData.values().stream().flatMap(Collection::stream).collect(Collectors.groupingBy(KiePMMLNameValue::getName));
        LinkedHashMap toReturn = new LinkedHashMap();
        mappedValues.forEach((key, probabilityValues) -> {
            Double value = MultipleModelMethodFunctions.doubleStream(probabilityValues.stream(), "AVERAGE").average().orElseThrow(() -> new KieEnumException("Failed to get AVERAGE"));
            toReturn.put(key, value);
        });
        return toReturn;
    };

    private MultipleModelMethodFunctions() {
    }

    private static Stream<Object> objectStream(Stream<KiePMMLNameValue> toUnwrap) {
        return toUnwrap.map(KiePMMLNameValue::getValue);
    }

    private static Stream<KiePMMLValueWeight> valueWeightStream(Stream<KiePMMLNameValue> toUnwrap, String enumName) {
        return toUnwrap.map(KiePMMLNameValue::getValue).map(elem -> {
            if (!(elem instanceof KiePMMLValueWeight)) {
                throw new KieEnumException("Failed to get " + enumName + ". Expecting KiePMMLValueWeight, found " + elem.getClass().getSimpleName());
            }
            return (KiePMMLValueWeight)elem;
        });
    }

    private static DoubleStream doubleStream(Stream<KiePMMLNameValue> toUnwrap, String enumName) {
        return MultipleModelMethodFunctions.valueWeightStream(toUnwrap, enumName).mapToDouble(KiePMMLValueWeight::getValue);
    }
}

