/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.mining.model.enums;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.AssertionsForClassTypes;
import org.assertj.core.data.Offset;
import org.junit.jupiter.api.Test;
import org.kie.pmml.api.exceptions.KieEnumException;
import org.kie.pmml.commons.model.tuples.KiePMMLNameValue;
import org.kie.pmml.commons.model.tuples.KiePMMLValueWeight;
import org.kie.pmml.models.mining.model.enums.MULTIPLE_MODEL_METHOD;

public class MULTIPLE_MODEL_METHODTest {
    private final Map<MULTIPLE_MODEL_METHOD, String> EXISTING_VALUES = Stream.of(new AbstractMap.SimpleEntry<MULTIPLE_MODEL_METHOD, String>(MULTIPLE_MODEL_METHOD.MAJORITY_VOTE, "majorityVote"), new AbstractMap.SimpleEntry<MULTIPLE_MODEL_METHOD, String>(MULTIPLE_MODEL_METHOD.WEIGHTED_MAJORITY_VOTE, "weightedMajorityVote"), new AbstractMap.SimpleEntry<MULTIPLE_MODEL_METHOD, String>(MULTIPLE_MODEL_METHOD.AVERAGE, "average"), new AbstractMap.SimpleEntry<MULTIPLE_MODEL_METHOD, String>(MULTIPLE_MODEL_METHOD.WEIGHTED_AVERAGE, "weightedAverage"), new AbstractMap.SimpleEntry<MULTIPLE_MODEL_METHOD, String>(MULTIPLE_MODEL_METHOD.MEDIAN, "median"), new AbstractMap.SimpleEntry<MULTIPLE_MODEL_METHOD, String>(MULTIPLE_MODEL_METHOD.WEIGHTED_MEDIAN, "x-weightedMedian"), new AbstractMap.SimpleEntry<MULTIPLE_MODEL_METHOD, String>(MULTIPLE_MODEL_METHOD.MAX, "max"), new AbstractMap.SimpleEntry<MULTIPLE_MODEL_METHOD, String>(MULTIPLE_MODEL_METHOD.SUM, "sum"), new AbstractMap.SimpleEntry<MULTIPLE_MODEL_METHOD, String>(MULTIPLE_MODEL_METHOD.WEIGHTED_SUM, "x-weightedSum"), new AbstractMap.SimpleEntry<MULTIPLE_MODEL_METHOD, String>(MULTIPLE_MODEL_METHOD.SELECT_FIRST, "selectFirst"), new AbstractMap.SimpleEntry<MULTIPLE_MODEL_METHOD, String>(MULTIPLE_MODEL_METHOD.SELECT_ALL, "selectAll"), new AbstractMap.SimpleEntry<MULTIPLE_MODEL_METHOD, String>(MULTIPLE_MODEL_METHOD.MODEL_CHAIN, "modelChain")).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    private final List<MULTIPLE_MODEL_METHOD> UNIMPLEMENTED = Arrays.asList(MULTIPLE_MODEL_METHOD.WEIGHTED_MAJORITY_VOTE, MULTIPLE_MODEL_METHOD.MODEL_CHAIN);

    @Test
    void byNameExisting() {
        this.EXISTING_VALUES.values().forEach(s -> Assertions.assertThat((Comparable)MULTIPLE_MODEL_METHOD.byName((String)s)).isNotNull());
    }

    @Test
    void byNameNotExisting() {
        AssertionsForClassTypes.assertThatExceptionOfType(KieEnumException.class).isThrownBy(() -> MULTIPLE_MODEL_METHOD.byName((String)"NOT_EXISTING"));
    }

    @Test
    void getName() {
        this.EXISTING_VALUES.forEach((multipleModelMethod, s) -> Assertions.assertThat((String)multipleModelMethod.getName()).isEqualTo(s));
    }

    @Test
    void applyMAJORITY_VOTE() {
        LinkedHashMap<String, KiePMMLNameValue> inputData = new LinkedHashMap<String, KiePMMLNameValue>();
        Object EXPECTED = 3;
        inputData.put("ValueA", new KiePMMLNameValue("valuea", (Object)1));
        inputData.put("ValueB", new KiePMMLNameValue("valueb", EXPECTED));
        inputData.put("ValueC", new KiePMMLNameValue("valuec", EXPECTED));
        inputData.put("ValueD", new KiePMMLNameValue("valuex", EXPECTED));
        inputData.put("ValueE", new KiePMMLNameValue("valueb", (Object)1));
        Object retrieved = MULTIPLE_MODEL_METHOD.MAJORITY_VOTE.applyPrediction(inputData);
        Assertions.assertThat((Object)retrieved).isEqualTo(EXPECTED);
        inputData = new LinkedHashMap();
        EXPECTED = "EXPECTED";
        inputData.put("ValueA", new KiePMMLNameValue("valuea", (Object)"dvsdv"));
        inputData.put("ValueB", new KiePMMLNameValue("valueb", EXPECTED));
        inputData.put("ValueC", new KiePMMLNameValue("valuec", (Object)"dssd"));
        inputData.put("ValueD", new KiePMMLNameValue("valuex", EXPECTED));
        inputData.put("ValueE", new KiePMMLNameValue("valueb", (Object)"vsd"));
        retrieved = MULTIPLE_MODEL_METHOD.MAJORITY_VOTE.applyPrediction(inputData);
        Assertions.assertThat((Object)retrieved).isEqualTo(EXPECTED);
    }

    @Test
    void applyWEIGHTED_MAJORITY_VOTE() {
        AssertionsForClassTypes.assertThatExceptionOfType(KieEnumException.class).isThrownBy(() -> {
            LinkedHashMap<String, KiePMMLNameValue> inputData = new LinkedHashMap<String, KiePMMLNameValue>();
            Integer EXPECTED = 3;
            inputData.put("ValueA", new KiePMMLNameValue("valuea", (Object)1));
            inputData.put("ValueB", new KiePMMLNameValue("valueb", (Object)EXPECTED));
            inputData.put("ValueC", new KiePMMLNameValue("valuec", (Object)EXPECTED));
            inputData.put("ValueD", new KiePMMLNameValue("valuex", (Object)EXPECTED));
            inputData.put("ValueE", new KiePMMLNameValue("valueb", (Object)1));
            MULTIPLE_MODEL_METHOD.WEIGHTED_MAJORITY_VOTE.applyPrediction(inputData);
        });
    }

    @Test
    void applyAVERAGEKiePMMLValueWeight() {
        Map<String, Object> expectedKiePMMLValueWeightMap = this.getExpectedKiePMMLValueWeightMap(true);
        double average = (Double)expectedKiePMMLValueWeightMap.get("average");
        LinkedHashMap inputData = (LinkedHashMap)expectedKiePMMLValueWeightMap.get("inputData");
        double retrieved = (Double)MULTIPLE_MODEL_METHOD.AVERAGE.applyPrediction(inputData);
        Assertions.assertThat((double)retrieved).isCloseTo(average, Offset.offset((Number)1.0E-13));
        expectedKiePMMLValueWeightMap = this.getExpectedKiePMMLValueWeightMap(false);
        average = (Double)expectedKiePMMLValueWeightMap.get("average");
        inputData = (LinkedHashMap)expectedKiePMMLValueWeightMap.get("inputData");
        retrieved = (Double)MULTIPLE_MODEL_METHOD.AVERAGE.applyPrediction(inputData);
        Assertions.assertThat((double)retrieved).isCloseTo(average, Offset.offset((Number)1.0E-13));
    }

    @Test
    void applyAVERAGENotKiePMMLValueWeight() {
        AssertionsForClassTypes.assertThatExceptionOfType(KieEnumException.class).isThrownBy(() -> {
            LinkedHashMap<String, KiePMMLNameValue> inputData = new LinkedHashMap<String, KiePMMLNameValue>();
            String EXPECTED = "EXPECTED";
            inputData.put("ValueA", new KiePMMLNameValue("valuea", (Object)"dvsdv"));
            inputData.put("ValueB", new KiePMMLNameValue("valueb", (Object)EXPECTED));
            inputData.put("ValueC", new KiePMMLNameValue("valuec", (Object)"dssd"));
            inputData.put("ValueD", new KiePMMLNameValue("valuex", (Object)EXPECTED));
            inputData.put("ValueE", new KiePMMLNameValue("valueb", (Object)"vsd"));
            MULTIPLE_MODEL_METHOD.AVERAGE.applyPrediction(inputData);
        });
    }

    @Test
    void applyWEIGHTED_AVERAGEKiePMMLValueWeight() {
        Map<String, Object> expectedKiePMMLValueWeightMap = this.getExpectedKiePMMLValueWeightMap(true);
        double weightedAverage = (Double)expectedKiePMMLValueWeightMap.get("weightedAverage");
        LinkedHashMap inputData = (LinkedHashMap)expectedKiePMMLValueWeightMap.get("inputData");
        double retrieved = (Double)MULTIPLE_MODEL_METHOD.WEIGHTED_AVERAGE.applyPrediction(inputData);
        Assertions.assertThat((double)retrieved).isCloseTo(weightedAverage, Offset.offset((Number)1.0E-13));
        expectedKiePMMLValueWeightMap = this.getExpectedKiePMMLValueWeightMap(false);
        weightedAverage = (Double)expectedKiePMMLValueWeightMap.get("weightedAverage");
        inputData = (LinkedHashMap)expectedKiePMMLValueWeightMap.get("inputData");
        retrieved = (Double)MULTIPLE_MODEL_METHOD.WEIGHTED_AVERAGE.applyPrediction(inputData);
        Assertions.assertThat((double)retrieved).isCloseTo(weightedAverage, Offset.offset((Number)1.0E-13));
    }

    @Test
    void applyWEIGHTED_AVERAGENotKiePMMLValueWeight() {
        AssertionsForClassTypes.assertThatExceptionOfType(KieEnumException.class).isThrownBy(() -> {
            LinkedHashMap<String, KiePMMLNameValue> inputData = new LinkedHashMap<String, KiePMMLNameValue>();
            String EXPECTED = "EXPECTED";
            inputData.put("ValueA", new KiePMMLNameValue("valuea", (Object)"dvsdv"));
            inputData.put("ValueB", new KiePMMLNameValue("valueb", (Object)EXPECTED));
            inputData.put("ValueC", new KiePMMLNameValue("valuec", (Object)"dssd"));
            inputData.put("ValueD", new KiePMMLNameValue("valuex", (Object)EXPECTED));
            inputData.put("ValueE", new KiePMMLNameValue("valueb", (Object)"vsd"));
            MULTIPLE_MODEL_METHOD.WEIGHTED_AVERAGE.applyPrediction(inputData);
        });
    }

    @Test
    void applyMEDIANNumbers() {
        Map<String, Object> expectedKiePMMLValueWeightMap = this.getExpectedKiePMMLValueWeightMap(true);
        double median = (Double)expectedKiePMMLValueWeightMap.get("median");
        LinkedHashMap inputData = (LinkedHashMap)expectedKiePMMLValueWeightMap.get("inputData");
        double retrieved = (Double)MULTIPLE_MODEL_METHOD.MEDIAN.applyPrediction(inputData);
        Assertions.assertThat((double)retrieved).isCloseTo(median, Offset.offset((Number)1.0E-13));
        expectedKiePMMLValueWeightMap = this.getExpectedKiePMMLValueWeightMap(false);
        median = (Double)expectedKiePMMLValueWeightMap.get("median");
        inputData = (LinkedHashMap)expectedKiePMMLValueWeightMap.get("inputData");
        retrieved = (Double)MULTIPLE_MODEL_METHOD.MEDIAN.applyPrediction(inputData);
        Assertions.assertThat((double)retrieved).isCloseTo(median, Offset.offset((Number)1.0E-13));
    }

    @Test
    void applyMEDIANNotNumbers() {
        AssertionsForClassTypes.assertThatExceptionOfType(KieEnumException.class).isThrownBy(() -> {
            LinkedHashMap<String, KiePMMLNameValue> inputData = new LinkedHashMap<String, KiePMMLNameValue>();
            String EXPECTED = "EXPECTED";
            inputData.put("ValueA", new KiePMMLNameValue("valuea", (Object)"dvsdv"));
            inputData.put("ValueB", new KiePMMLNameValue("valueb", (Object)EXPECTED));
            inputData.put("ValueC", new KiePMMLNameValue("valuec", (Object)"dssd"));
            inputData.put("ValueD", new KiePMMLNameValue("valuex", (Object)EXPECTED));
            inputData.put("ValueE", new KiePMMLNameValue("valueb", (Object)"vsd"));
            MULTIPLE_MODEL_METHOD.MEDIAN.applyPrediction(inputData);
        });
    }

    @Test
    void applyWEIGHTED_MEDIANNumbers() {
        Map<String, Object> expectedKiePMMLValueWeightMap = this.getExpectedKiePMMLValueWeightMap(true);
        double weightedMedian = (Double)expectedKiePMMLValueWeightMap.get("weightedMedian");
        LinkedHashMap inputData = (LinkedHashMap)expectedKiePMMLValueWeightMap.get("inputData");
        double retrieved = (Double)MULTIPLE_MODEL_METHOD.WEIGHTED_MEDIAN.applyPrediction(inputData);
        Assertions.assertThat((double)retrieved).isCloseTo(weightedMedian, Offset.offset((Number)1.0E-13));
        expectedKiePMMLValueWeightMap = this.getExpectedKiePMMLValueWeightMap(false);
        weightedMedian = (Double)expectedKiePMMLValueWeightMap.get("weightedMedian");
        inputData = (LinkedHashMap)expectedKiePMMLValueWeightMap.get("inputData");
        retrieved = (Double)MULTIPLE_MODEL_METHOD.WEIGHTED_MEDIAN.applyPrediction(inputData);
        Assertions.assertThat((double)retrieved).isCloseTo(weightedMedian, Offset.offset((Number)1.0E-13));
    }

    @Test
    void applyWEIGHTED_MEDIANNotNumbers() {
        AssertionsForClassTypes.assertThatExceptionOfType(KieEnumException.class).isThrownBy(() -> {
            LinkedHashMap<String, KiePMMLNameValue> inputData = new LinkedHashMap<String, KiePMMLNameValue>();
            String EXPECTED = "EXPECTED";
            inputData.put("ValueA", new KiePMMLNameValue("valuea", (Object)"dvsdv"));
            inputData.put("ValueB", new KiePMMLNameValue("valueb", (Object)EXPECTED));
            inputData.put("ValueC", new KiePMMLNameValue("valuec", (Object)"dssd"));
            inputData.put("ValueD", new KiePMMLNameValue("valuex", (Object)EXPECTED));
            inputData.put("ValueE", new KiePMMLNameValue("valueb", (Object)"vsd"));
            MULTIPLE_MODEL_METHOD.WEIGHTED_MEDIAN.applyPrediction(inputData);
        });
    }

    @Test
    void applyMAXNumbers() {
        Map<String, Object> expectedKiePMMLValueWeightMap = this.getExpectedKiePMMLValueWeightMap(true);
        double max = (Double)expectedKiePMMLValueWeightMap.get("max");
        LinkedHashMap inputData = (LinkedHashMap)expectedKiePMMLValueWeightMap.get("inputData");
        double retrieved = (Double)MULTIPLE_MODEL_METHOD.MAX.applyPrediction(inputData);
        Assertions.assertThat((double)retrieved).isCloseTo(max, Offset.offset((Number)1.0E-13));
        expectedKiePMMLValueWeightMap = this.getExpectedKiePMMLValueWeightMap(false);
        max = (Double)expectedKiePMMLValueWeightMap.get("max");
        inputData = (LinkedHashMap)expectedKiePMMLValueWeightMap.get("inputData");
        retrieved = (Double)MULTIPLE_MODEL_METHOD.MAX.applyPrediction(inputData);
        Assertions.assertThat((double)retrieved).isCloseTo(max, Offset.offset((Number)1.0E-13));
    }

    @Test
    void applyMAXNotNumbers() {
        AssertionsForClassTypes.assertThatExceptionOfType(KieEnumException.class).isThrownBy(() -> {
            LinkedHashMap<String, KiePMMLNameValue> inputData = new LinkedHashMap<String, KiePMMLNameValue>();
            String EXPECTED = "EXPECTED";
            inputData.put("ValueA", new KiePMMLNameValue("valuea", (Object)"dvsdv"));
            inputData.put("ValueB", new KiePMMLNameValue("valueb", (Object)EXPECTED));
            inputData.put("ValueC", new KiePMMLNameValue("valuec", (Object)"dssd"));
            inputData.put("ValueD", new KiePMMLNameValue("valuex", (Object)EXPECTED));
            inputData.put("ValueE", new KiePMMLNameValue("valueb", (Object)"vsd"));
            MULTIPLE_MODEL_METHOD.MAX.applyPrediction(inputData);
        });
    }

    @Test
    void applySUMNumbers() {
        Map<String, Object> expectedKiePMMLValueWeightMap = this.getExpectedKiePMMLValueWeightMap(true);
        double sum = (Double)expectedKiePMMLValueWeightMap.get("sum");
        LinkedHashMap inputData = (LinkedHashMap)expectedKiePMMLValueWeightMap.get("inputData");
        double retrieved = (Double)MULTIPLE_MODEL_METHOD.SUM.applyPrediction(inputData);
        Assertions.assertThat((double)retrieved).isCloseTo(sum, Offset.offset((Number)1.0E-13));
        expectedKiePMMLValueWeightMap = this.getExpectedKiePMMLValueWeightMap(false);
        sum = (Double)expectedKiePMMLValueWeightMap.get("sum");
        inputData = (LinkedHashMap)expectedKiePMMLValueWeightMap.get("inputData");
        retrieved = (Double)MULTIPLE_MODEL_METHOD.SUM.applyPrediction(inputData);
        Assertions.assertThat((double)retrieved).isCloseTo(sum, Offset.offset((Number)1.0E-13));
    }

    @Test
    void applySUMNotNumbers() {
        AssertionsForClassTypes.assertThatExceptionOfType(KieEnumException.class).isThrownBy(() -> {
            LinkedHashMap<String, KiePMMLNameValue> inputData = new LinkedHashMap<String, KiePMMLNameValue>();
            String EXPECTED = "EXPECTED";
            inputData.put("ValueA", new KiePMMLNameValue("valuea", (Object)"dvsdv"));
            inputData.put("ValueB", new KiePMMLNameValue("valueb", (Object)EXPECTED));
            inputData.put("ValueC", new KiePMMLNameValue("valuec", (Object)"dssd"));
            inputData.put("ValueD", new KiePMMLNameValue("valuex", (Object)EXPECTED));
            inputData.put("ValueE", new KiePMMLNameValue("valueb", (Object)"vsd"));
            MULTIPLE_MODEL_METHOD.SUM.applyPrediction(inputData);
        });
    }

    @Test
    void applyWEIGHTED_SUMNumbers() {
        Map<String, Object> expectedKiePMMLValueWeightMap = this.getExpectedKiePMMLValueWeightMap(true);
        double weightsSum = (Double)expectedKiePMMLValueWeightMap.get("weightedSum");
        LinkedHashMap inputData = (LinkedHashMap)expectedKiePMMLValueWeightMap.get("inputData");
        double retrieved = (Double)MULTIPLE_MODEL_METHOD.WEIGHTED_SUM.applyPrediction(inputData);
        Assertions.assertThat((double)retrieved).isCloseTo(weightsSum, Offset.offset((Number)1.0E-13));
        expectedKiePMMLValueWeightMap = this.getExpectedKiePMMLValueWeightMap(false);
        weightsSum = (Double)expectedKiePMMLValueWeightMap.get("weightedSum");
        inputData = (LinkedHashMap)expectedKiePMMLValueWeightMap.get("inputData");
        retrieved = (Double)MULTIPLE_MODEL_METHOD.WEIGHTED_SUM.applyPrediction(inputData);
        Assertions.assertThat((double)retrieved).isCloseTo(weightsSum, Offset.offset((Number)1.0E-13));
    }

    @Test
    void applyWEIGHTED_SUMNotNumbers() {
        AssertionsForClassTypes.assertThatExceptionOfType(KieEnumException.class).isThrownBy(() -> {
            LinkedHashMap<String, KiePMMLNameValue> inputData = new LinkedHashMap<String, KiePMMLNameValue>();
            String EXPECTED = "EXPECTED";
            inputData.put("ValueA", new KiePMMLNameValue("valuea", (Object)"dvsdv"));
            inputData.put("ValueB", new KiePMMLNameValue("valueb", (Object)EXPECTED));
            inputData.put("ValueC", new KiePMMLNameValue("valuec", (Object)"dssd"));
            inputData.put("ValueD", new KiePMMLNameValue("valuex", (Object)EXPECTED));
            inputData.put("ValueE", new KiePMMLNameValue("valueb", (Object)"vsd"));
            MULTIPLE_MODEL_METHOD.WEIGHTED_SUM.applyPrediction(inputData);
        });
    }

    @Test
    void applySELECT_FIRSTNumbers() {
        Map<String, Object> expectedKiePMMLValueWeightMap = this.getExpectedKiePMMLValueWeightMap(true);
        LinkedHashMap inputData = (LinkedHashMap)expectedKiePMMLValueWeightMap.get("inputData");
        double first = ((KiePMMLValueWeight)((KiePMMLNameValue)inputData.entrySet().iterator().next().getValue()).getValue()).getValue();
        double retrieved = (Double)MULTIPLE_MODEL_METHOD.SELECT_FIRST.applyPrediction(inputData);
        Assertions.assertThat((double)retrieved).isCloseTo(first, Offset.offset((Number)1.0E-13));
        expectedKiePMMLValueWeightMap = this.getExpectedKiePMMLValueWeightMap(false);
        inputData = (LinkedHashMap)expectedKiePMMLValueWeightMap.get("inputData");
        first = ((KiePMMLValueWeight)((KiePMMLNameValue)inputData.entrySet().iterator().next().getValue()).getValue()).getValue();
        retrieved = (Double)MULTIPLE_MODEL_METHOD.SELECT_FIRST.applyPrediction(inputData);
        Assertions.assertThat((double)retrieved).isCloseTo(first, Offset.offset((Number)1.0E-13));
    }

    @Test
    void applySELECT_FIRSTNotNumbers() {
        LinkedHashMap<String, KiePMMLNameValue> inputData = new LinkedHashMap<String, KiePMMLNameValue>();
        String EXPECTED = "EXPECTED";
        inputData.put("ValueA", new KiePMMLNameValue("valuea", (Object)EXPECTED));
        inputData.put("ValueB", new KiePMMLNameValue("valueb", (Object)"vdsvsd"));
        inputData.put("ValueC", new KiePMMLNameValue("valuec", (Object)"dssd"));
        inputData.put("ValueD", new KiePMMLNameValue("valuex", (Object)"vfdsvsdeeee"));
        inputData.put("ValueE", new KiePMMLNameValue("valueb", (Object)"vsd"));
        Object retrieved = MULTIPLE_MODEL_METHOD.SELECT_FIRST.applyPrediction(inputData);
        Assertions.assertThat((Object)retrieved).isEqualTo((Object)EXPECTED);
    }

    @Test
    void applySELECT_ALLNumbers() {
        Map<String, Object> expectedKiePMMLValueWeightMap = this.getExpectedKiePMMLValueWeightMap(true);
        LinkedHashMap inputData = (LinkedHashMap)expectedKiePMMLValueWeightMap.get("inputData");
        List expected = inputData.values().stream().map(kiePMMLNameValue -> ((KiePMMLValueWeight)kiePMMLNameValue.getValue()).getValue()).collect(Collectors.toList());
        List retrieved = (List)MULTIPLE_MODEL_METHOD.SELECT_ALL.applyPrediction(inputData);
        Assertions.assertThat((List)retrieved).hasSameSizeAs(expected);
        for (Double expDouble : expected) {
            Assertions.assertThat((List)retrieved).contains(new Object[]{expDouble});
        }
        expectedKiePMMLValueWeightMap = this.getExpectedKiePMMLValueWeightMap(false);
        inputData = (LinkedHashMap)expectedKiePMMLValueWeightMap.get("inputData");
        expected = inputData.values().stream().map(kiePMMLNameValue -> ((KiePMMLValueWeight)kiePMMLNameValue.getValue()).getValue()).collect(Collectors.toList());
        retrieved = (List)MULTIPLE_MODEL_METHOD.SELECT_ALL.applyPrediction(inputData);
        Assertions.assertThat((List)retrieved).hasSameSizeAs(expected);
        for (Double expDouble : expected) {
            Assertions.assertThat((List)retrieved).contains(new Object[]{expDouble});
        }
    }

    @Test
    void applySELECT_ALLNotNumbers() {
        LinkedHashMap<String, KiePMMLNameValue> inputData = new LinkedHashMap<String, KiePMMLNameValue>();
        inputData.put("ValueA", new KiePMMLNameValue("valuea", (Object)"fvdsfsdfsd"));
        inputData.put("ValueB", new KiePMMLNameValue("valueb", (Object)"vdsvsd"));
        inputData.put("ValueC", new KiePMMLNameValue("valuec", (Object)"dssd"));
        inputData.put("ValueD", new KiePMMLNameValue("valuex", (Object)"vfdsvsdeeee"));
        inputData.put("ValueE", new KiePMMLNameValue("valueb", (Object)"vsd"));
        List<Object> expected = inputData.values().stream().map(KiePMMLNameValue::getValue).collect(Collectors.toList());
        List retrieved = (List)MULTIPLE_MODEL_METHOD.SELECT_ALL.applyPrediction(inputData);
        Assertions.assertThat((List)retrieved).hasSameSizeAs(expected);
        expected.forEach(expString -> Assertions.assertThat((List)retrieved).contains(new Object[]{expString}));
    }

    @Test
    void applyMODEL_CHAIN() {
        AssertionsForClassTypes.assertThatExceptionOfType(KieEnumException.class).isThrownBy(() -> MULTIPLE_MODEL_METHOD.MODEL_CHAIN.applyPrediction(new LinkedHashMap()));
    }

    private Map<String, Object> getExpectedKiePMMLValueWeightMap(boolean evenNumberOfData) {
        LinkedHashMap<String, KiePMMLNameValue> inputData = new LinkedHashMap<String, KiePMMLNameValue>();
        int numberOfData = evenNumberOfData ? 8 : 9;
        ArrayList valueWeightList = new ArrayList();
        double seed = 0.35;
        AtomicReference<Double> WEIGHT_SEED = new AtomicReference<Double>(seed);
        IntStream.range(0, numberOfData).forEach(i -> {
            double weight;
            if (i < numberOfData - 1) {
                weight = ThreadLocalRandom.current().nextDouble(0.0, 1.0 - (Double)WEIGHT_SEED.get());
                WEIGHT_SEED.accumulateAndGet(weight, Double::sum);
            } else {
                weight = 1.0 - (Double)WEIGHT_SEED.get() + seed;
            }
            double value = ThreadLocalRandom.current().nextDouble(3.0, 10.0);
            valueWeightList.add(new KiePMMLValueWeight(value, weight));
        });
        double sum = 0.0;
        double weightedSum = 0.0;
        double weightsSum = 0.0;
        int i2 = 0;
        for (KiePMMLValueWeight valueWeight : valueWeightList) {
            inputData.put("Value" + i2, new KiePMMLNameValue("val-" + i2, (Object)valueWeight));
            sum += valueWeight.getValue();
            weightedSum += valueWeight.weightedValue();
            weightsSum += valueWeight.getWeight();
            ++i2;
        }
        HashMap<String, Object> toReturn = new HashMap<String, Object>();
        toReturn.put("inputData", inputData);
        toReturn.put("sum", sum);
        toReturn.put("weightedSum", weightedSum);
        double average = sum / (double)inputData.values().size();
        toReturn.put("average", average);
        double weightedAverage = weightedSum / weightsSum;
        toReturn.put("weightedAverage", weightedAverage);
        valueWeightList.sort((o1, o2) -> {
            int toReturn1 = 0;
            if (o1.getValue() > o2.getValue()) {
                toReturn1 = 1;
            } else if (o1.getValue() < o2.getValue()) {
                toReturn1 = -1;
            }
            return toReturn1;
        });
        double median = 0.0;
        median = evenNumberOfData ? (((KiePMMLValueWeight)valueWeightList.get(3)).getValue() + ((KiePMMLValueWeight)valueWeightList.get(4)).getValue()) / 2.0 : ((KiePMMLValueWeight)valueWeightList.get(4)).getValue();
        toReturn.put("median", median);
        double halfWeight = weightsSum / 2.0;
        double weightedMedianSum = 0.0;
        double weightedMedian = 0.0;
        for (KiePMMLValueWeight tuple : valueWeightList) {
            if (!((weightedMedianSum += tuple.getWeight()) >= halfWeight)) continue;
            weightedMedian = tuple.getValue();
            break;
        }
        toReturn.put("weightedMedian", weightedMedian);
        double max = ((KiePMMLValueWeight)valueWeightList.get(valueWeightList.size() - 1)).getValue();
        toReturn.put("max", max);
        return toReturn;
    }
}

