/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.mining.model;

import java.util.Collections;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.AssertionsForClassTypes;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.kie.pmml.api.enums.MINING_FUNCTION;
import org.kie.pmml.api.exceptions.KiePMMLException;
import org.kie.pmml.api.runtime.PMMLContext;
import org.kie.pmml.commons.testingutility.PMMLContextTest;
import org.kie.pmml.models.mining.model.AbstractKiePMMLMiningModelTest;
import org.kie.pmml.models.mining.model.KiePMMLMiningModel;
import org.kie.pmml.models.mining.model.segmentation.KiePMMLSegmentation;

public class KiePMMLMiningModelTest {
    private static final String MINING_MODEL_NAME = "MINING_MODEL_NAME";
    private static final MINING_FUNCTION MININGFUNCTION = MINING_FUNCTION.REGRESSION;
    private static KiePMMLMiningModel.Builder BUILDER;
    private static KiePMMLMiningModel KIE_PMML_MINING_MODEL;

    @BeforeAll
    public static void setup() {
        BUILDER = KiePMMLMiningModel.builder((String)MINING_MODEL_NAME, Collections.emptyList(), (MINING_FUNCTION)MININGFUNCTION);
        Assertions.assertThat((Object)BUILDER).isNotNull();
        KIE_PMML_MINING_MODEL = (KiePMMLMiningModel)BUILDER.build();
        Assertions.assertThat((Object)KIE_PMML_MINING_MODEL).isNotNull();
    }

    @Test
    void evaluate() {
        AssertionsForClassTypes.assertThatExceptionOfType(KiePMMLException.class).isThrownBy(() -> KIE_PMML_MINING_MODEL.evaluate((Object)"KB", Collections.EMPTY_MAP, (PMMLContext)new PMMLContextTest()));
    }

    @Test
    void getAlgorithmName() {
        Assertions.assertThat((String)KIE_PMML_MINING_MODEL.getAlgorithmName()).isNull();
        String algorithmName = "algorithmName";
        KIE_PMML_MINING_MODEL = (KiePMMLMiningModel)BUILDER.withAlgorithmName(algorithmName).build();
        Assertions.assertThat((String)KIE_PMML_MINING_MODEL.getAlgorithmName()).isEqualTo(algorithmName);
    }

    @Test
    void isScorable() {
        Assertions.assertThat((boolean)KIE_PMML_MINING_MODEL.isScorable()).isTrue();
        KIE_PMML_MINING_MODEL = (KiePMMLMiningModel)BUILDER.withScorable(false).build();
        Assertions.assertThat((boolean)KIE_PMML_MINING_MODEL.isScorable()).isFalse();
    }

    @Test
    void getSegmentation() {
        Assertions.assertThat((Object)KIE_PMML_MINING_MODEL.getSegmentation()).isNull();
        KiePMMLSegmentation segmentation = AbstractKiePMMLMiningModelTest.getKiePMMLSegmentation("SEGMENTATION_NAME");
        KIE_PMML_MINING_MODEL = (KiePMMLMiningModel)BUILDER.withSegmentation(segmentation).build();
        Assertions.assertThat((Object)KIE_PMML_MINING_MODEL.getSegmentation()).isEqualTo((Object)segmentation);
    }
}

