/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.mining.model;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.kie.pmml.api.enums.OPERATOR;
import org.kie.pmml.commons.model.KiePMMLModel;
import org.kie.pmml.commons.model.predicates.KiePMMLPredicate;
import org.kie.pmml.commons.model.predicates.KiePMMLSimplePredicate;
import org.kie.pmml.commons.testingutility.KiePMMLTestingModel;
import org.kie.pmml.models.mining.model.enums.MULTIPLE_MODEL_METHOD;
import org.kie.pmml.models.mining.model.segmentation.KiePMMLSegment;
import org.kie.pmml.models.mining.model.segmentation.KiePMMLSegmentation;

public abstract class AbstractKiePMMLMiningModelTest {
    public static KiePMMLSegmentation getKiePMMLSegmentation(String segmentationName) {
        return (KiePMMLSegmentation)KiePMMLSegmentation.builder((String)segmentationName, Collections.emptyList(), (MULTIPLE_MODEL_METHOD)MULTIPLE_MODEL_METHOD.AVERAGE).withSegments(AbstractKiePMMLMiningModelTest.getKiePMMLSegments()).build();
    }

    public static List<KiePMMLSegment> getKiePMMLSegments() {
        return IntStream.range(0, 3).mapToObj(i -> AbstractKiePMMLMiningModelTest.getKiePMMLSegment("SEGMENT-" + i)).collect(Collectors.toList());
    }

    public static KiePMMLSegment getKiePMMLSegment(String segmentName) {
        return (KiePMMLSegment)KiePMMLSegment.builder((String)segmentName, Collections.emptyList(), (KiePMMLPredicate)AbstractKiePMMLMiningModelTest.getKiePMMLSimplePredicate(segmentName + "-PREDICATE"), (KiePMMLModel)AbstractKiePMMLMiningModelTest.getKiePMMLModel(segmentName + "-MODEL")).build();
    }

    public static KiePMMLSimplePredicate getKiePMMLSimplePredicate(String predicateName) {
        return (KiePMMLSimplePredicate)KiePMMLSimplePredicate.builder((String)predicateName, Collections.emptyList(), (OPERATOR)OPERATOR.EQUAL).build();
    }

    public static KiePMMLModel getKiePMMLModel(String modelName) {
        return new KiePMMLTestingModel("fileName", modelName, Collections.emptyList());
    }
}

