/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.mining.tests;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import org.assertj.core.api.Assertions;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.pmml.PMML4Result;
import org.kie.pmml.commons.enums.ResultCode;
import org.kie.pmml.evaluator.api.executor.PMMLRuntime;
import org.kie.pmml.mining.tests.AbstractPMMLMiningTest;

@RunWith(value=Parameterized.class)
public class PredicatesMiningTest
extends AbstractPMMLMiningTest {
    private static final String MODEL_NAME = "PredicatesMining";
    private static final String TARGET_FIELD = "categoricalResult";
    private static PMMLRuntime pmmlRuntime;
    private String categoricalX;
    private String categoricalY;
    private double age;
    private String occupation;
    private String residenceState;
    private boolean validLicense;
    private double variable;
    private Double expectedResult;

    public PredicatesMiningTest(String residenceState, boolean validLicense, String occupation, String categoricalY, String categoricalX, double variable, double age, Double expectedResult) {
        this.residenceState = residenceState;
        this.validLicense = validLicense;
        this.occupation = occupation;
        this.categoricalY = categoricalY;
        this.categoricalX = categoricalX;
        this.variable = variable;
        this.age = age;
        this.expectedResult = expectedResult;
    }

    @BeforeClass
    public static void setupClass() {
        pmmlRuntime = PredicatesMiningTest.getPMMLRuntime(MODEL_NAME);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return Arrays.asList({"AP", true, "ASTRONAUT", "classA", "red", 23.6, 25.0, 21.345}, {"KN", true, "PROGRAMMER", "classA", "blue", 9.12, 2.3, -0.10000000000000053}, {"TN", false, "INSTRUCTOR", "classC", "yellow", 333.12, 33.56, null}, {"KN", true, "ASTRONAUT", "classB", "orange", 1.23, 30.12, 22.3725}, {"TN", false, "TEACHER", "classC", "green", 12.34, 22.12, 32.9}, {"AP", false, "INSTRUCTOR", "classB", "green", 2.2, 11.33, 12.899999999999999}, {"KN", true, "SKYDIVER", "classB", "orange", 9.12, 42.2, 11.448333333333332}, {"AP", false, "TEACHER", "classA", "yellow", 11.2, 12.1, -103.35});
    }

    @Test
    public void testPredicatesMining() {
        HashMap<String, Object> inputData = new HashMap<String, Object>();
        inputData.put("residenceState", this.residenceState);
        inputData.put("validLicense", this.validLicense);
        inputData.put("occupation", this.occupation);
        inputData.put("categoricalY", this.categoricalY);
        inputData.put("categoricalX", this.categoricalX);
        inputData.put("variable", this.variable);
        inputData.put("age", this.age);
        PMML4Result pmml4Result = this.evaluate(pmmlRuntime, inputData, MODEL_NAME);
        if (this.expectedResult != null) {
            Assertions.assertThat(pmml4Result.getResultVariables().get(TARGET_FIELD)).isNotNull();
            Assertions.assertThat((String)pmml4Result.getResultCode()).isEqualTo(ResultCode.OK.getName());
        } else {
            Assertions.assertThat(pmml4Result.getResultVariables().get(TARGET_FIELD)).isNull();
            Assertions.assertThat((String)pmml4Result.getResultCode()).isEqualTo(ResultCode.FAIL.getName());
        }
        Assertions.assertThat(pmml4Result.getResultVariables().get(TARGET_FIELD)).isEqualTo((Object)this.expectedResult);
    }
}

