/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.mining.tests;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import org.assertj.core.api.Assertions;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.pmml.PMML4Result;
import org.kie.pmml.evaluator.api.executor.PMMLRuntime;
import org.kie.pmml.mining.tests.AbstractPMMLMiningTest;

@RunWith(value=Parameterized.class)
public class SegmentationMedian2MiningTest
extends AbstractPMMLMiningTest {
    private static final String MODEL_NAME = "SegmentationMedian2Mining";
    private static final String TARGET_FIELD = "result";
    private static PMMLRuntime pmmlRuntime;
    private double x;
    private double y;
    private double result;

    public SegmentationMedian2MiningTest(double x, double y, double result) {
        this.x = x;
        this.y = y;
        this.result = result;
    }

    @BeforeClass
    public static void setupClass() {
        pmmlRuntime = SegmentationMedian2MiningTest.getPMMLRuntime(MODEL_NAME);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return Arrays.asList({-5, -25, -23865.5}, {0, 0, 2}, {2, 5, 242}, {12, -5, 4162}, {-1, 5, 216.5});
    }

    @Test
    public void testSegmentationMedianMiningTest() {
        HashMap<String, Object> inputData = new HashMap<String, Object>();
        inputData.put("x", this.x);
        inputData.put("y", this.y);
        PMML4Result pmml4Result = this.evaluate(pmmlRuntime, inputData, MODEL_NAME);
        Assertions.assertThat(pmml4Result.getResultVariables().get(TARGET_FIELD)).isNotNull();
        Assertions.assertThat(pmml4Result.getResultVariables().get(TARGET_FIELD)).isEqualTo((Object)this.result);
    }
}

