/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.mining.tests;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import org.assertj.core.api.Assertions;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.pmml.PMML4Result;
import org.kie.pmml.evaluator.api.executor.PMMLRuntime;
import org.kie.pmml.mining.tests.AbstractPMMLMiningTest;

@RunWith(value=Parameterized.class)
public class SegmentationSelectFirstMiningTest
extends AbstractPMMLMiningTest {
    private static final String MODEL_NAME = "SegmentationSelectFirstMining";
    private static final String TARGET_FIELD = "result";
    private static PMMLRuntime pmmlRuntime;
    private double x;
    private double y;
    private double result;

    public SegmentationSelectFirstMiningTest(double x, double y, double result) {
        this.x = x;
        this.y = y;
        this.result = result;
    }

    @BeforeClass
    public static void setupClass() {
        pmmlRuntime = SegmentationSelectFirstMiningTest.getPMMLRuntime(MODEL_NAME);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return Arrays.asList({0, 0, -10}, {1, 1, 3}, {20, 30, 121004}, {25, 31, 167502}, {5, 5, 55});
    }

    @Test
    public void testSegmentationMedianMiningTest() {
        HashMap<String, Object> inputData = new HashMap<String, Object>();
        inputData.put("x", this.x);
        inputData.put("y", this.y);
        PMML4Result pmml4Result = this.evaluate(pmmlRuntime, inputData, MODEL_NAME);
        Assertions.assertThat(pmml4Result.getResultVariables().get(TARGET_FIELD)).isNotNull();
        Assertions.assertThat(pmml4Result.getResultVariables().get(TARGET_FIELD)).isEqualTo((Object)this.result);
    }
}

