/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.mining.tests;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import org.assertj.core.api.Assertions;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.pmml.PMML4Result;
import org.kie.pmml.evaluator.api.executor.PMMLRuntime;
import org.kie.pmml.models.tests.AbstractPMMLTest;

@RunWith(value=Parameterized.class)
public class SegmentationMaxMiningTest
extends AbstractPMMLTest {
    private static final String FILE_NAME = "segmentationMaxMining.pmml";
    private static final String MODEL_NAME = "SegmentationMaxMining";
    private static final String TARGET_FIELD = "result";
    private static PMMLRuntime pmmlRuntime;
    private double x;
    private double y;
    private double result;

    public SegmentationMaxMiningTest(double x, double y, double result) {
        this.x = x;
        this.y = y;
        this.result = result;
    }

    @BeforeClass
    public static void setupClass() {
        pmmlRuntime = SegmentationMaxMiningTest.getPMMLRuntime((String)MODEL_NAME, (String)FILE_NAME);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return Arrays.asList({0, 0, 50}, {1, 1, 55}, {20, 30, 121004}, {25, 31, 167502}, {5, 5, 1004});
    }

    @Test
    public void testSegmentationMedianMiningTest() {
        HashMap<String, Double> inputData = new HashMap<String, Double>();
        inputData.put("x", this.x);
        inputData.put("y", this.y);
        PMML4Result pmml4Result = this.evaluate(pmmlRuntime, inputData, MODEL_NAME);
        Assertions.assertThat(pmml4Result.getResultVariables().get(TARGET_FIELD)).isNotNull();
        Assertions.assertThat(pmml4Result.getResultVariables().get(TARGET_FIELD)).isEqualTo((Object)this.result);
    }
}

