/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.mining.tests;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import org.assertj.core.api.Assertions;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.pmml.PMML4Result;
import org.kie.pmml.api.runtime.PMMLRuntime;
import org.kie.pmml.models.tests.AbstractPMMLTest;

@RunWith(value=Parameterized.class)
public class SegmentationClassificationSelectFirstTest
extends AbstractPMMLTest {
    private static final String FILE_NAME = "segmentationClassificationSelectFirst.pmml";
    private static final String MODEL_NAME = "SegmentationClassificationSelectFirst";
    private static final String TARGET_FIELD = "result";
    private static PMMLRuntime pmmlRuntime;
    private double input1;
    private double input2;
    private double input3;
    private String result;

    public SegmentationClassificationSelectFirstTest(double input1, double input2, double input3, String result) {
        this.input1 = input1;
        this.input2 = input2;
        this.input3 = input3;
        this.result = result;
    }

    @BeforeClass
    public static void setupClass() {
        pmmlRuntime = SegmentationClassificationSelectFirstTest.getPMMLRuntime((String)FILE_NAME);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return Arrays.asList({0, -1, 0, "classB1"}, {2, 20, 90, "classC1"}, {4, 20, 0, "classA1"}, {15, -1, 0, "classC2"}, {17, 20, 90, "classA2"}, {18, 20, 0, "classB2"}, {55, -1, 0, "classA3"}, {57, 20, 90, "classB3"}, {58, 20, 0, "classC3"}, {58, 20, -1, "classC3"});
    }

    @Test
    public void testSegmentationClassificationSelectFirstTest() {
        HashMap<String, Double> inputData = new HashMap<String, Double>();
        inputData.put("input1", this.input1);
        inputData.put("input2", this.input2);
        inputData.put("input3", this.input3);
        PMML4Result pmml4Result = this.evaluate(pmmlRuntime, inputData, MODEL_NAME);
        Assertions.assertThat(pmml4Result.getResultVariables().get(TARGET_FIELD)).isNotNull();
        Assertions.assertThat(pmml4Result.getResultVariables().get(TARGET_FIELD)).isEqualTo((Object)this.result);
    }
}

