/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.mining.tests;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.pmml.PMML4Result;
import org.kie.pmml.api.exceptions.KiePMMLException;
import org.kie.pmml.api.runtime.PMMLRuntime;
import org.kie.pmml.models.tests.AbstractPMMLTest;

@RunWith(value=Parameterized.class)
public class MixedMiningTest
extends AbstractPMMLTest {
    private static final String FILE_NAME = "MiningModel_Mixed.pmml";
    private static final String MODEL_NAME = "MixedMining";
    private static final String TARGET_FIELD = "categoricalResult";
    private static final String NUMBER_OF_CLAIMS = "Number of Claims";
    private static final String OUT_DER_FUN_OCCUPATION = "out_der_fun_occupation";
    private static final String OUT_RESIDENCESTATE = "out_residenceState";
    private static final String OUT_FUN_OCCUPATION_REFERRED = "out_fun_occupation_referred";
    private static final String CONSTANT_OCCUPATION = "CONSTANT_OCCUPATION";
    private static final String OUT_NORMDISCRETE_FIELD = "out_normdiscrete_field";
    private static final String OUT_DISCRETIZE_FIELD = "out_discretize_field";
    private static final String OUT_MAPVALUED_FIELD = "out_mapvalued_field";
    private static final String OUT_TEXT_INDEX_NORMALIZATION_FIELD = "out_text_index_normalization_field";
    private static final String TEXT_INPUT = "Testing the app for a few days convinced me the interfaces are excellent!";
    private static PMMLRuntime pmmlRuntime;
    private String categoricalX;
    private String categoricalY;
    private double age;
    private String occupation;
    private String residenceState;
    private boolean validLicense;
    private double expectedResult;

    public MixedMiningTest(String categoricalX, String categoricalY, double age, String occupation, String residenceState, boolean validLicense, double expectedResult) {
        this.categoricalX = categoricalX;
        this.categoricalY = categoricalY;
        this.age = age;
        this.occupation = occupation;
        this.residenceState = residenceState;
        this.validLicense = validLicense;
        this.expectedResult = expectedResult;
    }

    @BeforeClass
    public static void setupClass() {
        pmmlRuntime = MixedMiningTest.getPMMLRuntime((String)FILE_NAME);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return Arrays.asList({"red", "classA", 25.0, "ASTRONAUT", "AP", true, 17.0}, {"blue", "classA", 2.3, "PROGRAMMER", "KN", true, 36.0}, {"yellow", "classC", 333.56, "INSTRUCTOR", "TN", false, -58.0}, {"orange", "classB", 0.12, "ASTRONAUT", "KN", true, 33.0}, {"green", "classC", 122.12, "TEACHER", "TN", false, 123.0}, {"green", "classB", 11.33, "INSTRUCTOR", "AP", false, 76.0}, {"orange", "classB", 423.2, "SKYDIVER", "KN", true, 57.0});
    }

    @Test
    public void testMixedMining() throws Exception {
        String expected;
        HashMap<String, Object> inputData = new HashMap<String, Object>();
        inputData.put("categoricalX", this.categoricalX);
        inputData.put("categoricalY", this.categoricalY);
        inputData.put("age", this.age);
        inputData.put("occupation", this.occupation);
        inputData.put("residenceState", this.residenceState);
        inputData.put("validLicense", this.validLicense);
        inputData.put("text_input", TEXT_INPUT);
        inputData.put("input3", 34.1);
        PMML4Result pmml4Result = this.evaluate(pmmlRuntime, inputData, MODEL_NAME);
        Assertions.assertThat(pmml4Result.getResultVariables().get(TARGET_FIELD)).isNotNull();
        Assertions.assertThat(pmml4Result.getResultVariables().get(TARGET_FIELD)).isEqualTo((Object)this.expectedResult);
        Assertions.assertThat(pmml4Result.getResultVariables().get(NUMBER_OF_CLAIMS)).isNotNull();
        Assertions.assertThat(pmml4Result.getResultVariables().get(NUMBER_OF_CLAIMS)).isEqualTo((Object)this.expectedResult);
        Assertions.assertThat(pmml4Result.getResultVariables().get(OUT_DER_FUN_OCCUPATION)).isNotNull();
        Assertions.assertThat(pmml4Result.getResultVariables().get(OUT_DER_FUN_OCCUPATION)).isEqualTo((Object)this.occupation);
        Assertions.assertThat(pmml4Result.getResultVariables().get(OUT_RESIDENCESTATE)).isNotNull();
        Assertions.assertThat(pmml4Result.getResultVariables().get(OUT_RESIDENCESTATE)).isEqualTo((Object)this.residenceState);
        Assertions.assertThat(pmml4Result.getResultVariables().get(OUT_FUN_OCCUPATION_REFERRED)).isNotNull();
        Assertions.assertThat(pmml4Result.getResultVariables().get(OUT_FUN_OCCUPATION_REFERRED)).isEqualTo((Object)CONSTANT_OCCUPATION);
        Assertions.assertThat(pmml4Result.getResultVariables().get(OUT_NORMDISCRETE_FIELD)).isNotNull();
        if (this.occupation.equals("SKYDIVER")) {
            Assertions.assertThat(pmml4Result.getResultVariables().get(OUT_NORMDISCRETE_FIELD)).isEqualTo((Object)"1.0");
        } else {
            Assertions.assertThat(pmml4Result.getResultVariables().get(OUT_NORMDISCRETE_FIELD)).isEqualTo((Object)"0.0");
        }
        Assertions.assertThat(pmml4Result.getResultVariables().get(OUT_DISCRETIZE_FIELD)).isNotNull();
        if (this.age > 4.2 && this.age < 30.5) {
            Assertions.assertThat(pmml4Result.getResultVariables().get(OUT_DISCRETIZE_FIELD)).isEqualTo((Object)"abc");
        } else if (this.age >= 114.0 && this.age < 250.0) {
            Assertions.assertThat(pmml4Result.getResultVariables().get(OUT_DISCRETIZE_FIELD)).isEqualTo((Object)"def");
        } else {
            Assertions.assertThat(pmml4Result.getResultVariables().get(OUT_DISCRETIZE_FIELD)).isEqualTo((Object)"defaultValue");
        }
        Assertions.assertThat(pmml4Result.getResultVariables().get(OUT_MAPVALUED_FIELD)).isNotNull();
        switch (this.categoricalX) {
            case "red": {
                expected = "der";
                break;
            }
            case "green": {
                expected = "neerg";
                break;
            }
            case "blue": {
                expected = "eulb";
                break;
            }
            case "orange": {
                expected = "egnaro";
                break;
            }
            case "yellow": {
                expected = "wolley";
                break;
            }
            default: {
                throw new Exception("Unexpected categoricalX " + this.categoricalX);
            }
        }
        Assertions.assertThat(pmml4Result.getResultVariables().get(OUT_MAPVALUED_FIELD)).isEqualTo((Object)expected);
        Assertions.assertThat(pmml4Result.getResultVariables().get(OUT_TEXT_INDEX_NORMALIZATION_FIELD)).isNotNull();
        Assertions.assertThat(pmml4Result.getResultVariables().get(OUT_TEXT_INDEX_NORMALIZATION_FIELD)).isEqualTo((Object)1.0);
    }

    @Test(expected=KiePMMLException.class)
    public void testMixedMiningWithoutRequired() {
        HashMap<String, Object> inputData = new HashMap<String, Object>();
        inputData.put("categoricalX", this.categoricalX);
        inputData.put("categoricalY", this.categoricalY);
        inputData.put("age", this.age);
        inputData.put("occupation", this.occupation);
        inputData.put("residenceState", this.residenceState);
        inputData.put("validLicense", this.validLicense);
        inputData.put("text_input", TEXT_INPUT);
        this.evaluate(pmmlRuntime, inputData, MODEL_NAME);
    }

    @Test
    public void testMixedMiningConvertible() {
        HashMap<String, String> inputData = new HashMap<String, String>();
        inputData.put("categoricalX", this.categoricalX);
        inputData.put("categoricalY", this.categoricalY);
        inputData.put("age", String.valueOf(this.age));
        inputData.put("occupation", this.occupation);
        inputData.put("residenceState", this.residenceState);
        inputData.put("validLicense", String.valueOf(this.validLicense));
        inputData.put("text_input", TEXT_INPUT);
        inputData.put("input3", "34.1");
        Assert.assertNotNull((Object)this.evaluate(pmmlRuntime, inputData, MODEL_NAME));
    }

    @Test(expected=KiePMMLException.class)
    public void testMixedMiningNotConvertible() {
        HashMap<String, Object> inputData = new HashMap<String, Object>();
        inputData.put("categoricalX", this.categoricalX);
        inputData.put("categoricalY", this.categoricalY);
        inputData.put("age", this.age);
        inputData.put("occupation", this.occupation);
        inputData.put("residenceState", this.residenceState);
        inputData.put("validLicense", this.validLicense);
        inputData.put("text_input", TEXT_INPUT);
        inputData.put("input3", true);
        this.evaluate(pmmlRuntime, inputData, MODEL_NAME);
    }

    @Test(expected=KiePMMLException.class)
    public void testMixedMiningInvalidValue() {
        HashMap<String, Object> inputData = new HashMap<String, Object>();
        inputData.put("categoricalX", this.categoricalX);
        inputData.put("categoricalY", this.categoricalY);
        inputData.put("age", this.age);
        inputData.put("occupation", this.occupation);
        inputData.put("residenceState", this.residenceState);
        inputData.put("validLicense", this.validLicense);
        inputData.put("text_input", TEXT_INPUT);
        inputData.put("input3", 4.1);
        this.evaluate(pmmlRuntime, inputData, MODEL_NAME);
    }
}

