/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.mining.tests;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.kie.api.pmml.PMML4Result;
import org.kie.pmml.api.runtime.PMMLRuntime;
import org.kie.pmml.models.tests.AbstractPMMLTest;

public class MiningModelChainTest
extends AbstractPMMLTest {
    private static final String FILE_NAME = "MiningModelChain.pmml";
    private static final String MODEL_NAME = "SampleModelChainMine";
    private static final String TARGET_FIELD = "qualificationLevel";
    private final String AGE = "age";
    private final String OCCUPATION = "occupation";
    private final String RESIDENCESTATE = "residenceState";
    private final String VALIDLICENSE = "validLicense";
    private double age;
    private String occupation;
    private String residenceState;
    private boolean validLicense;
    private static PMMLRuntime pmmlRuntime;
    private String expectedResult;

    public void initMiningModelChainTest(double age, String occupation, String residenceState, boolean validLicense, String expectedResult) {
        this.age = age;
        this.occupation = occupation;
        this.residenceState = residenceState;
        this.validLicense = validLicense;
        this.expectedResult = expectedResult;
    }

    @BeforeAll
    public static void setupClass() {
        pmmlRuntime = MiningModelChainTest.getPMMLRuntime((String)FILE_NAME);
    }

    public static Collection<Object[]> data() {
        return Arrays.asList({25.0, "ASTRONAUT", "AP", true, "Barely"}, {2.3, "PROGRAMMER", "KN", true, "Unqualified"}, {333.56, "INSTRUCTOR", "TN", false, "Well"}, {0.12, "ASTRONAUT", "KN", true, "Unqualified"}, {122.12, "TEACHER", "TN", false, "Well"}, {11.33, "INSTRUCTOR", "AP", false, "Unqualified"}, {423.2, "SKYDIVER", "KN", true, "Barely"});
    }

    @MethodSource(value={"data"})
    @ParameterizedTest
    void testMiningModelChain(double age, String occupation, String residenceState, boolean validLicense, String expectedResult) throws Exception {
        this.initMiningModelChainTest(age, occupation, residenceState, validLicense, expectedResult);
        HashMap<String, Object> inputData = new HashMap<String, Object>();
        inputData.put("age", age);
        inputData.put("occupation", occupation);
        inputData.put("residenceState", residenceState);
        inputData.put("validLicense", validLicense);
        PMML4Result pmml4Result = this.evaluate(pmmlRuntime, inputData, MODEL_NAME);
        Assertions.assertThat(pmml4Result.getResultVariables().get(TARGET_FIELD)).isNotNull();
        Assertions.assertThat(pmml4Result.getResultVariables().get(TARGET_FIELD)).isEqualTo((Object)expectedResult);
    }
}

