/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.mining.tests;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.kie.api.pmml.PMML4Result;
import org.kie.pmml.api.runtime.PMMLRuntime;
import org.kie.pmml.models.tests.AbstractPMMLTest;

public class MiningModelSummedTest
extends AbstractPMMLTest {
    private static final String FILE_NAME_NO_SUFFIX = "MiningModelSummed";
    private static final String MODEL_NAME = "MiningModelSummed";
    private static final String TARGET_FIELD = "result";
    private final String INPUT1 = "input1";
    private final String INPUT2 = "input2";
    private final String INPUT3 = "input3";
    private double input1;
    private double input2;
    private double input3;
    private static PMMLRuntime pmmlRuntime;
    private double expectedResult;

    public void initMiningModelSummedTest(double input1, double input2, double input3, double expectedResult) {
        this.input1 = input1;
        this.input2 = input2;
        this.input3 = input3;
        this.expectedResult = expectedResult;
    }

    @BeforeAll
    public static void setupClass() {
        pmmlRuntime = MiningModelSummedTest.getPMMLRuntime((String)"MiningModelSummed");
    }

    public static Collection<Object[]> data() {
        return Arrays.asList(new Object[][]{{200.0, -1.0, 2.0, -299.0}});
    }

    @MethodSource(value={"data"})
    @ParameterizedTest
    void testMiningModelSummed(double input1, double input2, double input3, double expectedResult) throws Exception {
        this.initMiningModelSummedTest(input1, input2, input3, expectedResult);
        HashMap<String, Double> inputData = new HashMap<String, Double>();
        inputData.put("input1", input1);
        inputData.put("input2", input2);
        inputData.put("input3", input3);
        PMML4Result pmml4Result = this.evaluate(pmmlRuntime, inputData, "MiningModelSummed", "MiningModelSummed");
        Assertions.assertThat(pmml4Result.getResultVariables().get(TARGET_FIELD)).isNotNull();
        Assertions.assertThat(pmml4Result.getResultVariables().get(TARGET_FIELD)).isEqualTo((Object)expectedResult);
    }
}

