/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.mining.tests;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.kie.api.pmml.PMML4Result;
import org.kie.pmml.api.runtime.PMMLRuntime;
import org.kie.pmml.models.tests.AbstractPMMLTest;

public class MiningWithNestedRefersTest
extends AbstractPMMLTest {
    private static final String FILE_NAME_NO_SUFFIX = "MiningWithNestedRefers";
    private static final String MODEL_NAME = "MiningWithNestedRefers";
    private static final String TARGET_FIELD = "class";
    private static final String S_LEN = "s_len";
    private static final String S_WID = "s_wid";
    private static final String P_LEN = "p_len";
    private static final String P_WID = "p_wid";
    private static final String PROBABILITY_IRIS_SETOSA = "probability(Iris-setosa)";
    private static final String PROBABILITY_IRIS_VERSICOLOR = "probability(Iris-versicolor)";
    private static final String PROBABILITY_IRIS_VIRGINICA = "probability(Iris-virginica)";
    private static PMMLRuntime pmmlRuntime;
    private float sLen;
    private float sWid;
    private float pLen;
    private float pWid;
    private String expectedResult;
    private double pSetosa;
    private double pVersicolor;
    private double pVirginica;

    public void initMiningWithNestedRefersTest(float sLen, float sWid, float pLen, float pWid, double pSetosa, double pVersicolor, double pVirginica, String expectedResult) {
        this.sLen = sLen;
        this.sWid = sWid;
        this.pLen = pLen;
        this.pWid = pWid;
        this.pSetosa = pSetosa;
        this.pVersicolor = pVersicolor;
        this.pVirginica = pVirginica;
        this.expectedResult = expectedResult;
    }

    @BeforeAll
    public static void setupClass() {
        pmmlRuntime = MiningWithNestedRefersTest.getPMMLRuntime((String)"MiningWithNestedRefers");
    }

    public static Collection<Object[]> data() {
        return Arrays.asList(new Object[][]{{Float.valueOf(5.4f), Float.valueOf(3.9f), Float.valueOf(1.3f), Float.valueOf(0.4f), 1.1068470421580194, -0.1805270582839955, 0.07368001612597608, "setosa"}});
    }

    @MethodSource(value={"data"})
    @ParameterizedTest
    void testMiningWithNestedRefers(float sLen, float sWid, float pLen, float pWid, double pSetosa, double pVersicolor, double pVirginica, String expectedResult) throws Exception {
        this.initMiningWithNestedRefersTest(sLen, sWid, pLen, pWid, pSetosa, pVersicolor, pVirginica, expectedResult);
        HashMap<String, Float> inputData = new HashMap<String, Float>();
        inputData.put(S_LEN, Float.valueOf(sLen));
        inputData.put(S_WID, Float.valueOf(sWid));
        inputData.put(P_LEN, Float.valueOf(pLen));
        inputData.put(P_WID, Float.valueOf(pWid));
        PMML4Result pmml4Result = this.evaluate(pmmlRuntime, inputData, "MiningWithNestedRefers", "MiningWithNestedRefers");
        Assertions.assertThat(pmml4Result.getResultVariables().get(TARGET_FIELD)).isNotNull();
        Assertions.assertThat(pmml4Result.getResultVariables().get(TARGET_FIELD)).isEqualTo((Object)expectedResult);
    }
}

