/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.mining.tests;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.kie.api.pmml.PMML4Result;
import org.kie.pmml.api.runtime.PMMLRuntime;
import org.kie.pmml.models.tests.AbstractPMMLTest;

public class RandomForestClassifierMiningTest
extends AbstractPMMLTest {
    private static final String FILE_NAME_NO_SUFFIX = "RandomForestClassifier";
    private static final String MODEL_NAME = "RandomForestClassifier";
    private static final String TARGET_FIELD = "Approved";
    private static PMMLRuntime pmmlRuntime;
    private double age;
    private double debt;
    private double yearsEmployed;
    private double income;
    private int expectedResult;

    public void initRandomForestClassifierMiningTest(double age, double debt, double yearsEmployed, double income, int expectedResult) {
        this.age = age;
        this.debt = debt;
        this.yearsEmployed = yearsEmployed;
        this.income = income;
        this.expectedResult = expectedResult;
    }

    @BeforeAll
    public static void setupClass() {
        pmmlRuntime = RandomForestClassifierMiningTest.getPMMLRuntime((String)"RandomForestClassifier");
    }

    public static Collection<Object[]> data() {
        return Arrays.asList({40.83, 3.5, 0.5, 0, 0}, {32.25, 1.5, 0.25, 122, 0}, {28.17, 0.585, 0.04, 1004, 1}, {29.75, 0.665, 0.25, 0, 0});
    }

    @MethodSource(value={"data"})
    @ParameterizedTest
    void testMixedMining(double age, double debt, double yearsEmployed, double income, int expectedResult) {
        this.initRandomForestClassifierMiningTest(age, debt, yearsEmployed, income, expectedResult);
        HashMap<String, Double> inputData = new HashMap<String, Double>();
        inputData.put("Age", age);
        inputData.put("Debt", debt);
        inputData.put("YearsEmployed", yearsEmployed);
        inputData.put("Income", income);
        PMML4Result pmml4Result = this.evaluate(pmmlRuntime, inputData, "RandomForestClassifier", "RandomForestClassifier");
        Assertions.assertThat(pmml4Result.getResultVariables().get(TARGET_FIELD)).isNotNull();
        Assertions.assertThat(pmml4Result.getResultVariables().get(TARGET_FIELD)).isEqualTo((Object)expectedResult);
    }
}

