/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.mining.tests;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.kie.pmml.api.models.PMMLStep;
import org.kie.pmml.api.runtime.PMMLRuntime;
import org.kie.pmml.evaluator.core.implementations.PMMLRuntimeStep;
import org.kie.pmml.models.tests.AbstractPMMLTest;

public class MiningListenerTest
extends AbstractPMMLTest {
    private static final String FILE_NAME_NO_SUFFIX = "MultipleMining";
    private static final String MODEL_NAME = "MixedMining";
    private static PMMLRuntime pmmlRuntime;
    private String categoricalX;
    private String categoricalY;
    private double age;
    private String occupation;
    private String residenceState;
    private boolean validLicense;

    public void initMiningListenerTest(String categoricalX, String categoricalY, double age, String occupation, String residenceState, boolean validLicense) {
        this.categoricalX = categoricalX;
        this.categoricalY = categoricalY;
        this.age = age;
        this.occupation = occupation;
        this.residenceState = residenceState;
        this.validLicense = validLicense;
    }

    @BeforeAll
    public static void setupClass() {
        pmmlRuntime = MiningListenerTest.getPMMLRuntime((String)FILE_NAME_NO_SUFFIX);
    }

    public static Collection<Object[]> data() {
        return Arrays.asList({"red", "classA", 25.0, "ASTRONAUT", "AP", true}, {"blue", "classA", 2.3, "PROGRAMMER", "KN", true}, {"yellow", "classC", 333.56, "INSTRUCTOR", "TN", false}, {"orange", "classB", 0.12, "ASTRONAUT", "KN", true}, {"green", "classC", 122.12, "TEACHER", "TN", false}, {"green", "classB", 11.33, "INSTRUCTOR", "AP", false}, {"orange", "classB", 423.2, "SKYDIVER", "KN", true});
    }

    @MethodSource(value={"data"})
    @ParameterizedTest
    void testMixedMining(String categoricalX, String categoricalY, double age, String occupation, String residenceState, boolean validLicense) {
        this.initMiningListenerTest(categoricalX, categoricalY, age, occupation, residenceState, validLicense);
        HashMap<String, Object> inputData = new HashMap<String, Object>();
        inputData.put("categoricalX", categoricalX);
        inputData.put("categoricalY", categoricalY);
        inputData.put("age", age);
        inputData.put("occupation", occupation);
        inputData.put("residenceState", residenceState);
        inputData.put("validLicense", validLicense);
        Set pmmlListeners = IntStream.range(0, 3).mapToObj(i -> this.getPMMLListener()).collect(Collectors.toSet());
        this.evaluate(pmmlRuntime, inputData, FILE_NAME_NO_SUFFIX, MODEL_NAME, pmmlListeners);
        List retrieved = ((AbstractPMMLTest.PMMLListenerTest)pmmlListeners.iterator().next()).getSteps();
        retrieved.stream().filter(pmmlStep -> !(pmmlStep instanceof PMMLRuntimeStep)).collect(Collectors.toList()).forEach(this::commonValidateStep);
        this.commonValidateListeners(pmmlListeners, retrieved);
    }

    private void commonValidateStep(PMMLStep toValidate) {
        Map retrieved = toValidate.getInfo();
        Assertions.assertThat((boolean)retrieved.containsKey("SEGMENT")).isTrue();
        Assertions.assertThat((boolean)retrieved.containsKey("RESULT CODE")).isTrue();
        Assertions.assertThat((boolean)retrieved.containsKey("MODEL")).isTrue();
        Assertions.assertThat((boolean)retrieved.containsKey("RESULT")).isTrue();
    }
}

