/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.mining.tests;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.kie.api.pmml.PMML4Result;
import org.kie.pmml.api.runtime.PMMLRuntime;
import org.kie.pmml.models.tests.AbstractPMMLTest;

public class SegmentationSelectFirstMiningTest
extends AbstractPMMLTest {
    private static final String FILE_NAME_NO_SUFFIX = "segmentationSelectFirstMining";
    private static final String MODEL_NAME = "SegmentationSelectFirstMining";
    private static final String TARGET_FIELD = "result";
    private static PMMLRuntime pmmlRuntime;
    private double x;
    private double y;
    private double result;

    public void initSegmentationSelectFirstMiningTest(double x, double y, double result) {
        this.x = x;
        this.y = y;
        this.result = result;
    }

    @BeforeAll
    public static void setupClass() {
        pmmlRuntime = SegmentationSelectFirstMiningTest.getPMMLRuntime((String)FILE_NAME_NO_SUFFIX);
    }

    public static Collection<Object[]> data() {
        return Arrays.asList({0, 0, -10}, {1, 1, 3}, {20, 30, 121004}, {25, 31, 167502}, {5, 5, 55});
    }

    @MethodSource(value={"data"})
    @ParameterizedTest
    void testSegmentationMedianMiningTest(double x, double y, double result) {
        this.initSegmentationSelectFirstMiningTest(x, y, result);
        HashMap<String, Double> inputData = new HashMap<String, Double>();
        inputData.put("x", x);
        inputData.put("y", y);
        PMML4Result pmml4Result = this.evaluate(pmmlRuntime, inputData, FILE_NAME_NO_SUFFIX, MODEL_NAME);
        Assertions.assertThat(pmml4Result.getResultVariables().get(TARGET_FIELD)).isNotNull();
        Assertions.assertThat(pmml4Result.getResultVariables().get(TARGET_FIELD)).isEqualTo((Object)result);
    }
}

