/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.tree.model;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;
import org.kie.pmml.commons.model.tuples.KiePMMLProbabilityConfidence;
import org.kie.pmml.models.tree.model.KiePMMLNode;
import org.kie.pmml.models.tree.model.KiePMMLScoreDistribution;
import org.kie.pmml.models.tree.model.KiePMMLTreeTestUtils;

public class KiePMMLNodeTest {
    @Test
    public void getProbabilityConfidenceMap() {
        LinkedHashMap retrieved = KiePMMLNode.getProbabilityConfidenceMap(null, (double)1.0);
        Assert.assertNotNull((Object)retrieved);
        Assert.assertTrue((boolean)retrieved.isEmpty());
        retrieved = KiePMMLNode.getProbabilityConfidenceMap(Collections.emptyList(), (double)1.0);
        Assert.assertNotNull((Object)retrieved);
        Assert.assertTrue((boolean)retrieved.isEmpty());
        List<KiePMMLScoreDistribution> kiePMMLScoreDistributions = KiePMMLTreeTestUtils.getRandomKiePMMLScoreDistributions(false);
        retrieved = KiePMMLNode.getProbabilityConfidenceMap(kiePMMLScoreDistributions, (double)1.0);
        Assert.assertNotNull((Object)retrieved);
        Assert.assertEquals((long)kiePMMLScoreDistributions.size(), (long)retrieved.size());
    }

    @Test
    public void evaluateProbabilityConfidenceMap() {
        List<KiePMMLScoreDistribution> kiePMMLScoreDistributions = KiePMMLTreeTestUtils.getRandomKiePMMLScoreDistributions(false);
        int totalRecordCount = kiePMMLScoreDistributions.stream().map(KiePMMLScoreDistribution::getRecordCount).reduce(0, Integer::sum);
        double missingValuePenalty = (double)new Random().nextInt(100) / 10.0;
        LinkedHashMap retrievedNoProbability = KiePMMLNode.getProbabilityConfidenceMap(kiePMMLScoreDistributions, (double)missingValuePenalty);
        Assert.assertNotNull((Object)retrievedNoProbability);
        kiePMMLScoreDistributions.forEach(kiePMMLScoreDistribution -> {
            Assert.assertTrue((boolean)retrievedNoProbability.containsKey(kiePMMLScoreDistribution.getValue()));
            KiePMMLProbabilityConfidence kiePMMLProbabilityConfidence = (KiePMMLProbabilityConfidence)retrievedNoProbability.get(kiePMMLScoreDistribution.getValue());
            Assert.assertNotNull((Object)kiePMMLProbabilityConfidence);
            double probabilityExpected = (double)kiePMMLScoreDistribution.getRecordCount() / (double)totalRecordCount;
            double confidenceExpected = kiePMMLScoreDistribution.getConfidence() * missingValuePenalty;
            Assert.assertEquals((double)probabilityExpected, (double)kiePMMLProbabilityConfidence.getProbability(), (double)1.0E-9);
            Assert.assertEquals((double)confidenceExpected, (double)kiePMMLProbabilityConfidence.getConfidence(), (double)1.0E-9);
        });
        kiePMMLScoreDistributions = KiePMMLTreeTestUtils.getRandomKiePMMLScoreDistributions(true);
        LinkedHashMap retrievedProbability = KiePMMLNode.getProbabilityConfidenceMap(kiePMMLScoreDistributions, (double)missingValuePenalty);
        Assert.assertNotNull((Object)retrievedNoProbability);
        kiePMMLScoreDistributions.forEach(kiePMMLScoreDistribution -> {
            Assert.assertTrue((boolean)retrievedProbability.containsKey(kiePMMLScoreDistribution.getValue()));
            KiePMMLProbabilityConfidence kiePMMLProbabilityConfidence = (KiePMMLProbabilityConfidence)retrievedProbability.get(kiePMMLScoreDistribution.getValue());
            Assert.assertNotNull((Object)kiePMMLProbabilityConfidence);
            double probabilityExpected = kiePMMLScoreDistribution.getProbability();
            double confidenceExpected = kiePMMLScoreDistribution.getConfidence() * missingValuePenalty;
            Assert.assertEquals((double)probabilityExpected, (double)kiePMMLProbabilityConfidence.getProbability(), (double)1.0E-9);
            Assert.assertEquals((double)confidenceExpected, (double)kiePMMLProbabilityConfidence.getConfidence(), (double)1.0E-9);
        });
    }
}

