/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.tree.model;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.assertj.core.api.Assertions;
import org.assertj.core.data.Offset;
import org.junit.jupiter.api.Test;
import org.kie.pmml.commons.model.tuples.KiePMMLProbabilityConfidence;
import org.kie.pmml.models.tree.model.KiePMMLNode;
import org.kie.pmml.models.tree.model.KiePMMLScoreDistribution;
import org.kie.pmml.models.tree.model.KiePMMLTreeTestUtils;

public class KiePMMLNodeTest {
    @Test
    void getProbabilityConfidenceMap() {
        LinkedHashMap retrieved = KiePMMLNode.getProbabilityConfidenceMap(null, (double)1.0);
        Assertions.assertThat((Map)retrieved).isNotNull();
        Assertions.assertThat((Map)retrieved).isEmpty();
        retrieved = KiePMMLNode.getProbabilityConfidenceMap(Collections.emptyList(), (double)1.0);
        Assertions.assertThat((Map)retrieved).isNotNull();
        Assertions.assertThat((Map)retrieved).isEmpty();
        List<KiePMMLScoreDistribution> kiePMMLScoreDistributions = KiePMMLTreeTestUtils.getRandomKiePMMLScoreDistributions(false);
        retrieved = KiePMMLNode.getProbabilityConfidenceMap(kiePMMLScoreDistributions, (double)1.0);
        Assertions.assertThat((Map)retrieved).isNotNull();
        Assertions.assertThat((Map)retrieved).hasSameSizeAs(kiePMMLScoreDistributions);
    }

    @Test
    void evaluateProbabilityConfidenceMap() {
        List<KiePMMLScoreDistribution> kiePMMLScoreDistributions = KiePMMLTreeTestUtils.getRandomKiePMMLScoreDistributions(false);
        int totalRecordCount = kiePMMLScoreDistributions.stream().map(KiePMMLScoreDistribution::getRecordCount).reduce(0, Integer::sum);
        double missingValuePenalty = (double)new Random().nextInt(100) / 10.0;
        LinkedHashMap retrievedNoProbability = KiePMMLNode.getProbabilityConfidenceMap(kiePMMLScoreDistributions, (double)missingValuePenalty);
        Assertions.assertThat((Map)retrievedNoProbability).isNotNull();
        kiePMMLScoreDistributions.forEach(kiePMMLScoreDistribution -> {
            Assertions.assertThat((Map)retrievedNoProbability).containsKey((Object)kiePMMLScoreDistribution.getValue());
            KiePMMLProbabilityConfidence kiePMMLProbabilityConfidence = (KiePMMLProbabilityConfidence)retrievedNoProbability.get(kiePMMLScoreDistribution.getValue());
            Assertions.assertThat((Object)kiePMMLProbabilityConfidence).isNotNull();
            double probabilityExpected = (double)kiePMMLScoreDistribution.getRecordCount() / (double)totalRecordCount;
            double confidenceExpected = kiePMMLScoreDistribution.getConfidence() * missingValuePenalty;
            Assertions.assertThat((double)kiePMMLProbabilityConfidence.getProbability()).isCloseTo(probabilityExpected, Offset.offset((Number)1.0E-9));
            Assertions.assertThat((Double)kiePMMLProbabilityConfidence.getConfidence()).isCloseTo(confidenceExpected, Offset.offset((Number)1.0E-9));
        });
        kiePMMLScoreDistributions = KiePMMLTreeTestUtils.getRandomKiePMMLScoreDistributions(true);
        LinkedHashMap retrievedProbability = KiePMMLNode.getProbabilityConfidenceMap(kiePMMLScoreDistributions, (double)missingValuePenalty);
        Assertions.assertThat((Map)retrievedNoProbability).isNotNull();
        kiePMMLScoreDistributions.forEach(kiePMMLScoreDistribution -> {
            Assertions.assertThat((Map)retrievedProbability).containsKey((Object)kiePMMLScoreDistribution.getValue());
            KiePMMLProbabilityConfidence kiePMMLProbabilityConfidence = (KiePMMLProbabilityConfidence)retrievedProbability.get(kiePMMLScoreDistribution.getValue());
            Assertions.assertThat((Object)kiePMMLProbabilityConfidence).isNotNull();
            double probabilityExpected = kiePMMLScoreDistribution.getProbability();
            double confidenceExpected = kiePMMLScoreDistribution.getConfidence() * missingValuePenalty;
            Assertions.assertThat((double)kiePMMLProbabilityConfidence.getProbability()).isCloseTo(probabilityExpected, Offset.offset((Number)1.0E-9));
            Assertions.assertThat((Double)kiePMMLProbabilityConfidence.getConfidence()).isCloseTo(confidenceExpected, Offset.offset((Number)1.0E-9));
        });
    }
}

