/*
 * Decompiled with CFR 0.152.
 */
package org.kie.remote.impl;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.kie.remote.RemoteStatefulSession;
import org.kie.remote.TopicsConfig;
import org.kie.remote.command.FireAllRulesCommand;
import org.kie.remote.command.FireUntilHaltCommand;
import org.kie.remote.command.HaltCommand;
import org.kie.remote.impl.consumer.Listener;
import org.kie.remote.impl.producer.Sender;

public class RemoteStatefulSessionImpl
implements RemoteStatefulSession {
    private final Sender sender;
    private final Listener listener;
    private final TopicsConfig topicsConfig;

    public RemoteStatefulSessionImpl(Sender sender, Listener listener, TopicsConfig topicsConfig) {
        this.sender = sender;
        this.listener = listener;
        this.topicsConfig = topicsConfig;
    }

    @Override
    public CompletableFuture<Long> fireAllRules() {
        FireAllRulesCommand command = new FireAllRulesCommand();
        CompletableFuture<Long> callback = new CompletableFuture<Long>();
        this.getRequestsStore().put(command.getId(), callback);
        this.sender.sendCommand(command, this.topicsConfig.getEventsTopicName());
        return callback;
    }

    public Map<String, CompletableFuture<Object>> getRequestsStore() {
        return this.listener.getRequestsStore();
    }

    @Override
    public void fireUntilHalt() {
        this.sender.sendCommand(new FireUntilHaltCommand(), this.topicsConfig.getEventsTopicName());
    }

    @Override
    public void halt() {
        this.sender.sendCommand(new HaltCommand(), this.topicsConfig.getEventsTopicName());
    }

    public void stop() {
        this.listener.stopConsumeEvents();
    }
}

