/*
 * Decompiled with CFR 0.152.
 */
package org.kie.remote.util;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public class LocalMessageSystem {
    private Map<String, BlockingQueue<Object>> queues = new HashMap<String, BlockingQueue<Object>>();

    private LocalMessageSystem() {
    }

    private BlockingQueue<Object> queueForTopic(String topic) {
        return this.queues.computeIfAbsent(topic, k -> new LinkedBlockingQueue());
    }

    public void put(String topic, Object message) {
        this.queueForTopic(topic).offer(message);
    }

    public Object peek(String topic) {
        return this.queueForTopic(topic).peek();
    }

    public Object poll(String topic) {
        return this.queueForTopic(topic).poll();
    }

    public Object poll(String topic, int durationMillis) {
        try {
            return this.queueForTopic(topic).poll(durationMillis, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public static LocalMessageSystem get() {
        return LazyHolder.get();
    }

    private static class LazyHolder {
        private static final LocalMessageSystem INSTANCE = new LocalMessageSystem();

        private LazyHolder() {
        }

        public static LocalMessageSystem get() {
            return INSTANCE;
        }
    }
}

