/*
 * Decompiled with CFR 0.152.
 */
package org.kie.remote.impl.consumer;

import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import org.kie.remote.exceptions.StopConsumeException;
import org.kie.remote.impl.consumer.ListenerThread;
import org.kie.remote.util.ConfigurationUtil;

public class Listener {
    private final Map<String, CompletableFuture<Object>> requestsStore = new ConcurrentHashMap<String, CompletableFuture<Object>>();
    private final ListenerThread listenerThread;
    private Thread t;

    public Listener(Properties configuration, ListenerThread listenerThread) {
        this.listenerThread = listenerThread;
        this.listenerThread.init(this.requestsStore);
        if (!ConfigurationUtil.readBoolean(configuration, "skip.listener.autostart")) {
            this.start();
        }
    }

    public Listener start() {
        this.t = new Thread(this.listenerThread);
        this.t.setDaemon(true);
        this.t.start();
        return this;
    }

    public Map<String, CompletableFuture<Object>> getRequestsStore() {
        return this.requestsStore;
    }

    public void stopConsumeEvents() {
        this.listenerThread.stop();
        this.requestsStore.clear();
        if (this.t != null) {
            try {
                this.t.join();
            }
            catch (InterruptedException ex) {
                this.t.interrupt();
                throw new StopConsumeException(ex.getMessage(), ex);
            }
        }
    }
}

