/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.impl;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import org.drools.core.command.runtime.BatchExecutionCommandImpl;
import org.drools.core.command.runtime.GetGlobalCommand;
import org.drools.core.command.runtime.SetGlobalCommand;
import org.drools.core.command.runtime.process.AbortWorkItemCommand;
import org.drools.core.command.runtime.process.CompleteWorkItemCommand;
import org.drools.core.command.runtime.process.SignalEventCommand;
import org.drools.core.command.runtime.process.StartProcessCommand;
import org.drools.core.command.runtime.rule.DeleteCommand;
import org.drools.core.command.runtime.rule.FireAllRulesCommand;
import org.drools.core.command.runtime.rule.GetObjectCommand;
import org.drools.core.command.runtime.rule.GetObjectsCommand;
import org.drools.core.command.runtime.rule.InsertElementsCommand;
import org.drools.core.command.runtime.rule.InsertObjectCommand;
import org.drools.core.command.runtime.rule.ModifyCommand;
import org.drools.core.command.runtime.rule.QueryCommand;
import org.drools.core.common.DefaultFactHandle;
import org.drools.core.runtime.help.impl.XStreamXML;
import org.drools.core.runtime.impl.ExecutionResultImpl;
import org.drools.core.runtime.rule.impl.FlatQueryResults;

public class XStreamXml {
    public static XStream newXStreamMarshaller(ClassLoader classLoader) {
        XStream xstream = new XStream();
        xstream.setClassLoader(classLoader);
        XStreamXml.setAliases(xstream);
        xstream.addImplicitCollection(BatchExecutionCommandImpl.class, "commands");
        XStreamXml.registerConverters(xstream);
        return xstream;
    }

    private static void registerConverters(XStream xstream) {
        xstream.registerConverter((Converter)new XStreamXML.InsertConverter(xstream));
        xstream.registerConverter((Converter)new XStreamXML.RetractConverter(xstream));
        xstream.registerConverter((Converter)new XStreamXML.ModifyConverter(xstream));
        xstream.registerConverter((Converter)new XStreamXML.GetObjectConverter(xstream));
        xstream.registerConverter((Converter)new XStreamXML.InsertElementsConverter(xstream));
        xstream.registerConverter((Converter)new XStreamXML.FireAllRulesConverter(xstream));
        xstream.registerConverter((Converter)new XStreamXML.StartProcessConvert(xstream));
        xstream.registerConverter((Converter)new XStreamXML.SignalEventConverter(xstream));
        xstream.registerConverter((Converter)new XStreamXML.CompleteWorkItemConverter(xstream));
        xstream.registerConverter((Converter)new XStreamXML.AbortWorkItemConverter(xstream));
        xstream.registerConverter((Converter)new XStreamXML.QueryConverter(xstream));
        xstream.registerConverter((Converter)new XStreamXML.SetGlobalConverter(xstream));
        xstream.registerConverter((Converter)new XStreamXML.GetGlobalConverter(xstream));
        xstream.registerConverter((Converter)new XStreamXML.GetObjectsConverter(xstream));
        xstream.registerConverter((Converter)new XStreamXML.BatchExecutionResultConverter(xstream));
        xstream.registerConverter((Converter)new XStreamXML.QueryResultsConverter(xstream));
        xstream.registerConverter((Converter)new XStreamXML.FactHandleConverter(xstream));
    }

    public static void setAliases(XStream xstream) {
        xstream.alias("batch-execution", BatchExecutionCommandImpl.class);
        xstream.alias("insert", InsertObjectCommand.class);
        xstream.alias("modify", ModifyCommand.class);
        xstream.alias("setters", ModifyCommand.SetterImpl.class);
        xstream.alias("retract", DeleteCommand.class);
        xstream.alias("insert-elements", InsertElementsCommand.class);
        xstream.alias("start-process", StartProcessCommand.class);
        xstream.alias("signal-event", SignalEventCommand.class);
        xstream.alias("complete-work-item", CompleteWorkItemCommand.class);
        xstream.alias("abort-work-item", AbortWorkItemCommand.class);
        xstream.alias("set-global", SetGlobalCommand.class);
        xstream.alias("get-global", GetGlobalCommand.class);
        xstream.alias("get-object", GetObjectCommand.class);
        xstream.alias("get-objects", GetObjectsCommand.class);
        xstream.alias("execution-results", ExecutionResultImpl.class);
        xstream.alias("fire-all-rules", FireAllRulesCommand.class);
        xstream.alias("query", QueryCommand.class);
        xstream.alias("query-results", FlatQueryResults.class);
        xstream.alias("fact-handle", DefaultFactHandle.class);
    }
}

