/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.api;

import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.kie.server.api.commands.CommandScript;
import org.kie.server.api.model.KieContainerResource;
import org.kie.server.api.model.KieScannerResource;
import org.kie.server.api.model.ReleaseId;

public interface KieServer {
    @GET
    @Produces(value={"application/xml", "application/json"})
    public Response getInfo(@Context HttpHeaders var1);

    @POST
    @Consumes(value={"application/xml", "application/json"})
    @Produces(value={"application/xml", "application/json"})
    public Response execute(@Context HttpHeaders var1, CommandScript var2);

    @GET
    @Path(value="containers")
    @Produces(value={"application/xml", "application/json"})
    public Response listContainers(@Context HttpHeaders var1);

    @GET
    @Path(value="containers/{id}")
    @Produces(value={"application/xml", "application/json"})
    public Response getContainerInfo(@Context HttpHeaders var1, @PathParam(value="id") String var2);

    @PUT
    @Path(value="containers/{id}")
    @Consumes(value={"application/xml", "application/json"})
    @Produces(value={"application/xml", "application/json"})
    public Response createContainer(@Context HttpHeaders var1, @PathParam(value="id") String var2, KieContainerResource var3);

    @DELETE
    @Path(value="containers/{id}")
    @Produces(value={"application/xml", "application/json"})
    public Response disposeContainer(@Context HttpHeaders var1, @PathParam(value="id") String var2);

    @POST
    @Path(value="containers/{id}")
    @Consumes(value={"application/xml", "application/json"})
    @Produces(value={"application/xml", "application/json"})
    public Response execute(@Context HttpHeaders var1, @PathParam(value="id") String var2, String var3);

    @GET
    @Path(value="containers/{id}/release-id")
    @Produces(value={"application/xml", "application/json"})
    public Response getReleaseId(@Context HttpHeaders var1, @PathParam(value="id") String var2);

    @POST
    @Path(value="containers/{id}/release-id")
    @Consumes(value={"application/xml", "application/json"})
    @Produces(value={"application/xml", "application/json"})
    public Response updateReleaseId(@Context HttpHeaders var1, @PathParam(value="id") String var2, ReleaseId var3);

    @GET
    @Path(value="containers/{id}/scanner")
    @Produces(value={"application/xml", "application/json"})
    public Response getScannerInfo(@Context HttpHeaders var1, @PathParam(value="id") String var2);

    @POST
    @Path(value="containers/{id}/scanner")
    @Consumes(value={"application/xml", "application/json"})
    @Produces(value={"application/xml", "application/json"})
    public Response updateScanner(@Context HttpHeaders var1, @PathParam(value="id") String var2, KieScannerResource var3);
}

