/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.rest;

import javax.ws.rs.Path;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Variant;
import org.kie.remote.common.rest.RestEasy960Util;
import org.kie.server.api.commands.CommandScript;
import org.kie.server.api.model.KieContainerResource;
import org.kie.server.api.model.KieScannerResource;
import org.kie.server.api.model.ReleaseId;
import org.kie.server.api.model.ServiceResponse;
import org.kie.server.api.model.ServiceResponsesList;
import org.kie.server.services.api.KieServer;
import org.kie.server.services.impl.KieServerImpl;
import org.kie.server.services.impl.KieServerLocator;

@Path(value="/server")
public class KieServerRestImpl
implements KieServer {
    private KieServerImpl server;

    public KieServerRestImpl() {
        this.server = KieServerLocator.getInstance();
    }

    public KieServerRestImpl(KieServerImpl server) {
        this.server = server;
    }

    public KieServerImpl getServer() {
        return this.server;
    }

    public void setServer(KieServerImpl server) {
        this.server = server;
    }

    @Override
    public Response getInfo(HttpHeaders headers) {
        return KieServerRestImpl.createCorrectVariant(this.server.getInfo(), headers);
    }

    @Override
    public Response execute(HttpHeaders headers, CommandScript command) {
        return KieServerRestImpl.createCorrectVariant(new GenericEntity<ServiceResponsesList>(this.server.executeScript(command)){}, headers);
    }

    @Override
    public Response listContainers(HttpHeaders headers) {
        return KieServerRestImpl.createCorrectVariant(this.server.listContainers(), headers);
    }

    @Override
    public Response createContainer(HttpHeaders headers, String id, KieContainerResource container) {
        ServiceResponse<KieContainerResource> response = this.server.createContainer(id, container);
        if (response.getType() == ServiceResponse.ResponseType.SUCCESS) {
            return KieServerRestImpl.createCorrectVariant(response, headers, Response.Status.CREATED);
        }
        return KieServerRestImpl.createCorrectVariant(response, headers, Response.Status.BAD_REQUEST);
    }

    @Override
    public Response getContainerInfo(HttpHeaders headers, String id) {
        return KieServerRestImpl.createCorrectVariant(this.server.getContainerInfo(id), headers);
    }

    @Override
    public Response disposeContainer(HttpHeaders headers, String id) {
        return KieServerRestImpl.createCorrectVariant(this.server.disposeContainer(id), headers);
    }

    @Override
    public Response execute(HttpHeaders headers, String id, String cmdPayload) {
        return KieServerRestImpl.createCorrectVariant(this.server.callContainer(id, cmdPayload), headers);
    }

    @Override
    public Response getScannerInfo(HttpHeaders headers, String id) {
        return KieServerRestImpl.createCorrectVariant(this.server.getScannerInfo(id), headers);
    }

    @Override
    public Response updateScanner(HttpHeaders headers, String id, KieScannerResource resource) {
        return KieServerRestImpl.createCorrectVariant(this.server.updateScanner(id, resource), headers);
    }

    @Override
    public Response getReleaseId(HttpHeaders headers, String id) {
        return KieServerRestImpl.createCorrectVariant(this.server.getContainerReleaseId(id), headers);
    }

    @Override
    public Response updateReleaseId(HttpHeaders headers, String id, ReleaseId releaseId) {
        return KieServerRestImpl.createCorrectVariant(this.server.updateContainerReleaseId(id, releaseId), headers);
    }

    protected static Response createCorrectVariant(Object responseObj, HttpHeaders headers) {
        return KieServerRestImpl.createCorrectVariant(responseObj, headers, null);
    }

    protected static Response createCorrectVariant(Object responseObj, HttpHeaders headers, Response.Status status) {
        Response.ResponseBuilder responseBuilder = null;
        Variant v = RestEasy960Util.getVariant((HttpHeaders)headers);
        if (v == null) {
            v = RestEasy960Util.defaultVariant;
        }
        responseBuilder = status != null ? Response.status((Response.Status)status).entity(responseObj).variant(v) : Response.ok((Object)responseObj, (Variant)v);
        return responseBuilder.build();
    }
}

