/*
 * Decompiled with CFR 0.152.
 */
package org.kie.spring;

import java.util.HashMap;
import java.util.Map;
import org.drools.compiler.kie.builder.impl.KieContainerImpl;
import org.drools.compiler.kie.builder.impl.KieProject;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.builder.ReleaseId;
import org.kie.api.builder.model.KieSessionModel;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.api.runtime.StatelessKieSession;

public class KieObjectsResolver {
    private Map<ReleaseId, KieContainer> gavs;
    private KieContainerImpl defaultClasspathKContainer;
    private static final KieObjectsResolver INSTANCE = new KieObjectsResolver();

    private KieObjectsResolver() {
        this.init();
    }

    public static KieObjectsResolver get() {
        return INSTANCE;
    }

    protected void init() {
        KieServices ks = KieServices.Factory.get();
        this.gavs = new HashMap<ReleaseId, KieContainer>();
        this.defaultClasspathKContainer = (KieContainerImpl)ks.getKieClasspathContainer();
    }

    public KieBase resolveKBase(String id, ReleaseId releaseId) {
        KieContainer kieContainer = this.resolveKContainer(releaseId);
        KieBase kieBase = kieContainer.getKieBase(id);
        if (kieBase == null) {
            kieBase = kieContainer.newKieBase(id, null);
        }
        return kieBase;
    }

    public Object resolveKSession(String id, ReleaseId releaseId) {
        KieContainer kieContainer = this.resolveKContainer(releaseId);
        KieProject kProject = ((KieContainerImpl)kieContainer).getKieProject();
        KieSessionModel kieSessionModel = kProject.getKieSessionModel(id);
        if (kieSessionModel.getType() == KieSessionModel.KieSessionType.STATEFUL) {
            return ((KieContainerImpl)kieContainer).getKieSession(id);
        }
        if (kieSessionModel.getType() == KieSessionModel.KieSessionType.STATELESS) {
            return ((KieContainerImpl)kieContainer).getStatelessKieSession(id);
        }
        return null;
    }

    private KieContainer resolveKContainer(ReleaseId releaseId) {
        Object kieContainer = null;
        kieContainer = releaseId == null ? this.defaultClasspathKContainer : this.gavs.get(releaseId);
        return kieContainer;
    }

    public StatelessKieSession newStatelessSession(String kbaseName, ReleaseId releaseId, KieSessionConfiguration conf) {
        KieBase kieBase = this.resolveKBase(kbaseName, releaseId);
        if (kieBase == null) {
            KieContainer kieContainer = this.resolveKContainer(releaseId);
            if (conf == null) {
                return kieContainer.newStatelessKieSession();
            }
            return kieContainer.newStatelessKieSession(conf);
        }
        if (conf == null) {
            return kieBase.newStatelessKieSession();
        }
        return kieBase.newStatelessKieSession(conf);
    }

    public Object newStatefulSession(String kbaseName, ReleaseId releaseId, KieSessionConfiguration conf) {
        KieBase kieBase = this.resolveKBase(kbaseName, releaseId);
        if (kieBase == null) {
            KieContainer kieContainer = this.resolveKContainer(releaseId);
            if (conf == null) {
                return kieContainer.newKieSession(kbaseName);
            }
            return kieContainer.newKieSession(conf);
        }
        if (conf == null) {
            return kieBase.newKieSession();
        }
        return kieBase.newKieSession(conf, null);
    }
}

