/*
 * Decompiled with CFR 0.152.
 */
package org.kie.spring;

import java.lang.reflect.Method;
import java.net.URL;
import java.util.Map;
import org.drools.compiler.kie.builder.impl.ClasspathKieProject;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.compiler.kie.builder.impl.KieBuilderImpl;
import org.drools.compiler.kproject.ReleaseIdImpl;
import org.drools.compiler.kproject.models.KieBaseModelImpl;
import org.drools.compiler.kproject.models.KieModuleModelImpl;
import org.drools.compiler.kproject.models.KieSessionModelImpl;
import org.kie.api.KieServices;
import org.kie.api.builder.KieModule;
import org.kie.api.builder.ReleaseId;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.api.builder.model.KieSessionModel;
import org.kie.api.conf.EqualityBehaviorOption;
import org.kie.api.conf.EventProcessingOption;
import org.kie.spring.KieSpringUtils;
import org.kie.spring.factorybeans.KBaseFactoryBean;
import org.kie.spring.factorybeans.KModuleFactoryBean;
import org.kie.spring.factorybeans.KSessionFactoryBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class KModuleBeanFactoryPostProcessor
implements BeanFactoryPostProcessor,
ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(KModuleBeanFactoryPostProcessor.class);
    protected URL configFileURL;
    protected ReleaseId releaseId;
    private String configFilePath;
    private ApplicationContext context;

    public KModuleBeanFactoryPostProcessor() {
        this.initConfigFilePath();
    }

    public KModuleBeanFactoryPostProcessor(URL configFileURL, String configFilePath, ApplicationContext context) {
        this.configFileURL = configFileURL;
        this.configFilePath = configFilePath;
        this.context = context;
    }

    public KModuleBeanFactoryPostProcessor(URL configFileURL, String configFilePath) {
        this.configFileURL = configFileURL;
        this.configFilePath = configFilePath;
    }

    protected void initConfigFilePath() {
        this.configFilePath = this.getClass().getResource("/").getPath();
    }

    public void setReleaseId(ReleaseId releaseId) {
        this.releaseId = releaseId;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        log.info(":: BeanFactoryPostProcessor::postProcessBeanFactory called ::");
        if (this.releaseId == null && this.configFilePath != null) {
            String pomProperties = ClasspathKieProject.getPomProperties((String)this.configFilePath);
            this.releaseId = ReleaseIdImpl.fromPropertiesString((String)pomProperties);
            KieSpringUtils.setDefaultReleaseId(this.releaseId);
        }
        for (String beanDef : beanFactory.getBeanDefinitionNames()) {
            BeanDefinition beanDefinition = beanFactory.getBeanDefinition(beanDef);
            if (!beanDefinition.getBeanClassName().equalsIgnoreCase(KModuleFactoryBean.class.getName())) continue;
            KieModuleModel kieModuleModel = this.fetchKieModuleModel(beanFactory);
            this.addKieModuleToRepo(kieModuleModel);
        }
    }

    private void addKieModuleToRepo(KieModuleModel kieProject) {
        KieBuilderImpl.setDefaultsforEmptyKieModule((KieModuleModel)kieProject);
        InternalKieModule kJar = this.createKieModule(kieProject);
        if (kJar != null) {
            KieServices ks = KieServices.Factory.get();
            log.info("adding KieModule from " + this.configFileURL.toExternalForm() + " to repository.");
            ks.getRepository().addKieModule((KieModule)kJar);
            KieSpringUtils.setReleaseIdForContext(this.releaseId, this.context);
        }
    }

    protected InternalKieModule createKieModule(KieModuleModel kieProject) {
        String rootPath;
        if (this.configFileURL.toString().startsWith("bundle:")) {
            return this.createOsgiKModule(kieProject);
        }
        if (this.configFilePath == null) {
            this.configFilePath = this.getClass().getResource("/").getPath();
        }
        if ((rootPath = this.configFilePath).lastIndexOf(58) > 0) {
            rootPath = this.configFilePath.substring(rootPath.lastIndexOf(58) + 1);
        }
        return ClasspathKieProject.createInternalKieModule((URL)this.configFileURL, (String)this.configFilePath, (KieModuleModel)kieProject, (ReleaseId)this.releaseId, (String)rootPath);
    }

    private InternalKieModule createOsgiKModule(KieModuleModel kieProject) {
        Method m;
        try {
            Class<?> c = Class.forName("org.drools.osgi.compiler.OsgiKieModule", true, KieBuilderImpl.class.getClassLoader());
            m = c.getMethod("create", URL.class, ReleaseId.class, KieModuleModel.class);
        }
        catch (Exception e) {
            throw new RuntimeException("It is necessary to have the drools-osgi-integration module on the path in order to create a KieProject from an ogsi bundle", e);
        }
        try {
            return (InternalKieModule)m.invoke(null, this.configFileURL, this.releaseId, kieProject);
        }
        catch (Exception e) {
            throw new RuntimeException("Failure creating a OsgiKieModule caused by: " + e.getMessage(), e);
        }
    }

    private KieModuleModel fetchKieModuleModel(ConfigurableListableBeanFactory beanFactory) {
        KieModuleModelImpl kieModuleModel = new KieModuleModelImpl();
        this.addKieBaseModels(beanFactory, kieModuleModel);
        return kieModuleModel;
    }

    private void addKieBaseModels(ConfigurableListableBeanFactory beanFactory, KieModuleModelImpl kieModuleModel) {
        for (String beanDef : beanFactory.getBeanDefinitionNames()) {
            String scope;
            String equalsBehavior;
            String eventMode;
            String includes;
            BeanDefinition beanDefinition = beanFactory.getBeanDefinition(beanDef);
            if (!beanDefinition.getBeanClassName().equalsIgnoreCase(KBaseFactoryBean.class.getName())) continue;
            KieBaseModelImpl kBase = new KieBaseModelImpl();
            kBase.setKModule((KieModuleModel)kieModuleModel);
            kBase.setName(this.getPropertyValue(beanDefinition, "kBaseName"));
            kBase.setDefault("true".equals(this.getPropertyValue(beanDefinition, "default")));
            String packages = this.getPropertyValue(beanDefinition, "packages");
            if (!packages.isEmpty()) {
                for (String pkg : packages.split(",")) {
                    kBase.addPackage(pkg.trim());
                }
            }
            if (!(includes = this.getPropertyValue(beanDefinition, "includes")).isEmpty()) {
                for (String include : includes.split(",")) {
                    kBase.addInclude(include.trim());
                }
            }
            if (!(eventMode = this.getPropertyValue(beanDefinition, "eventProcessingMode")).isEmpty()) {
                kBase.setEventProcessingMode(EventProcessingOption.determineEventProcessingMode((String)eventMode));
            }
            if (!(equalsBehavior = this.getPropertyValue(beanDefinition, "equalsBehavior")).isEmpty()) {
                kBase.setEqualsBehavior(EqualityBehaviorOption.valueOf((String)equalsBehavior.toUpperCase()));
            }
            if (!(scope = this.getPropertyValue(beanDefinition, "scope")).isEmpty()) {
                kBase.setScope(scope.trim());
            }
            kieModuleModel.getRawKieBaseModels().put(kBase.getName(), kBase);
            beanDefinition.getPropertyValues().addPropertyValue(new PropertyValue("releaseId", (Object)this.releaseId));
            this.addKieSessionModels(beanFactory, kBase);
        }
    }

    private String getPropertyValue(BeanDefinition beanDefinition, String propertyName) {
        PropertyValue propertyValue = beanDefinition.getPropertyValues().getPropertyValue(propertyName);
        return propertyValue != null ? (String)propertyValue.getValue() : "";
    }

    private void addKieSessionModels(ConfigurableListableBeanFactory beanFactory, KieBaseModelImpl kBase) {
        for (String beanDef : beanFactory.getBeanDefinitionNames()) {
            BeanDefinition beanDefinition = beanFactory.getBeanDefinition(beanDef);
            if (!beanDefinition.getBeanClassName().equalsIgnoreCase(KSessionFactoryBean.class.getName())) continue;
            String name = this.getPropertyValue(beanDefinition, "name");
            String type = this.getPropertyValue(beanDefinition, "type");
            String kBaseName = this.getPropertyValue(beanDefinition, "kBaseName");
            if (!kBase.getName().equalsIgnoreCase(kBaseName)) continue;
            KieSessionModelImpl kSession = new KieSessionModelImpl(kBase, name);
            kSession.setType(!type.isEmpty() ? KieSessionModel.KieSessionType.valueOf((String)type.toUpperCase()) : KieSessionModel.KieSessionType.STATEFUL);
            Map rawKieSessionModels = kBase.getRawKieSessionModels();
            rawKieSessionModels.put(kSession.getName(), kSession);
            beanDefinition.getPropertyValues().addPropertyValue(new PropertyValue("releaseId", (Object)this.releaseId));
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        try {
            this.configFileURL = applicationContext.getResource("classpath:/").getURL();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

