/*
 * Decompiled with CFR 0.152.
 */
package org.kie.spring.persistence;

import org.drools.persistence.TransactionManager;
import org.drools.persistence.TransactionSynchronization;
import org.kie.spring.persistence.SpringTransactionSynchronizationAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.AbstractPlatformTransactionManager;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class KieSpringTransactionManager
implements TransactionManager {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    private AbstractPlatformTransactionManager ptm;
    TransactionDefinition td = new DefaultTransactionDefinition();
    TransactionStatus currentTransaction = null;

    public KieSpringTransactionManager(AbstractPlatformTransactionManager ptm) {
        this.ptm = ptm;
    }

    public boolean begin() {
        try {
            if (this.getStatus() == 3) {
                this.currentTransaction = this.ptm.getTransaction(this.td);
                return true;
            }
            return false;
        }
        catch (Exception e) {
            this.logger.warn("Unable to begin transaction", (Throwable)e);
            throw new RuntimeException("Unable to begin transaction", e);
        }
    }

    public void commit(boolean transactionOwner) {
        if (transactionOwner) {
            try {
                this.ptm.commit(this.currentTransaction);
                this.currentTransaction = null;
            }
            catch (Exception e) {
                this.logger.warn("Unable to commit transaction", (Throwable)e);
                throw new RuntimeException("Unable to commit transaction", e);
            }
        }
    }

    public void rollback(boolean transactionOwner) {
        try {
            if (transactionOwner) {
                this.ptm.rollback(this.currentTransaction);
                this.currentTransaction = null;
            }
        }
        catch (Exception e) {
            this.logger.warn("Unable to rollback transaction", (Throwable)e);
            throw new RuntimeException("Unable to rollback transaction", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getStatus() {
        if (this.ptm == null) {
            return 3;
        }
        this.logger.debug("Current TX name (According to TransactionSynchronizationManager) : " + TransactionSynchronizationManager.getCurrentTransactionName());
        if (TransactionSynchronizationManager.isActualTransactionActive()) {
            TransactionStatus transaction = null;
            try {
                if (this.currentTransaction == null) {
                    transaction = this.ptm.getTransaction(this.td);
                    if (transaction.isNewTransaction()) {
                        int n = 0;
                        return n;
                    }
                } else {
                    transaction = this.currentTransaction;
                }
                this.logger.debug("Current TX: " + transaction);
                if (transaction.isCompleted()) {
                    if (transaction.isRollbackOnly()) {
                        int n = 1;
                        return n;
                    }
                    int n = 0;
                    return n;
                }
                int n = 4;
                return n;
            }
            finally {
                if (this.currentTransaction == null) {
                    this.ptm.commit(transaction);
                }
            }
        }
        return 3;
    }

    public void registerTransactionSynchronization(TransactionSynchronization ts) {
        TransactionSynchronizationManager.registerSynchronization((org.springframework.transaction.support.TransactionSynchronization)new SpringTransactionSynchronizationAdapter(ts));
    }
}

