/*
 * Decompiled with CFR 0.152.
 */
package org.kie.spring.tests.persistence;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.naming.NamingException;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import org.drools.compiler.kproject.ReleaseIdImpl;
import org.drools.core.base.MapGlobalResolver;
import org.drools.core.marshalling.impl.ClassObjectMarshallingStrategyAcceptor;
import org.drools.core.marshalling.impl.SerializablePlaceholderResolverStrategy;
import org.drools.persistence.jpa.marshaller.JPAPlaceholderResolverStrategy;
import org.h2.tools.DeleteDbFiles;
import org.h2.tools.Server;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.builder.ReleaseId;
import org.kie.api.marshalling.ObjectMarshallingStrategy;
import org.kie.api.marshalling.ObjectMarshallingStrategyAcceptor;
import org.kie.api.persistence.jpa.KieStoreServices;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkflowProcessInstance;
import org.kie.internal.KnowledgeBaseFactory;
import org.kie.internal.persistence.jpa.JPAKnowledgeService;
import org.kie.internal.runtime.StatefulKnowledgeSession;
import org.kie.spring.InternalKieSpringUtils;
import org.kie.spring.beans.persistence.MyEntity;
import org.kie.spring.beans.persistence.MyEntityMethods;
import org.kie.spring.beans.persistence.MyEntityOnlyFields;
import org.kie.spring.beans.persistence.MyVariableSerializable;
import org.kie.spring.beans.persistence.TestWorkItemHandler;
import org.kie.spring.tests.InternalKieSpringUtilsTest;
import org.kie.spring.tests.persistence.JPASingleSessionCommandServiceFactoryTest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

public class VariablePersistenceStrategyTest {
    private static final Logger log = LoggerFactory.getLogger(JPASingleSessionCommandServiceFactoryTest.class);
    private static Server h2Server;
    private ApplicationContext ctx;

    @BeforeClass
    public static void startH2Database() throws Exception {
        DeleteDbFiles.execute((String)"", (String)"DroolsFlow", (boolean)true);
        h2Server = Server.createTcpServer((String[])new String[0]);
        h2Server.start();
    }

    @AfterClass
    public static void stopH2Database() throws Exception {
        log.info("stoping database");
        h2Server.stop();
        DeleteDbFiles.execute((String)"", (String)"DroolsFlow", (boolean)true);
    }

    @Before
    public void createSpringContext() {
        try {
            log.info("creating spring context");
            ReleaseIdImpl releaseId = new ReleaseIdImpl("kie-spring-var-jpa", "test-spring", "0001");
            URL configFileURL = InternalKieSpringUtilsTest.class.getResource("/org/kie/spring/persistence/persistence_var_beans.xml");
            this.ctx = InternalKieSpringUtils.getSpringContext((ReleaseId)releaseId, (URL)configFileURL);
        }
        catch (Exception e) {
            log.error("can't create spring context", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @After
    public void destroySpringContext() {
        log.info("destroy spring context");
    }

    @Test
    public void testTransactionsRollback() throws Exception {
        final ArrayList list = new ArrayList();
        PlatformTransactionManager txManager = (PlatformTransactionManager)this.ctx.getBean("txManager");
        final Environment env = KnowledgeBaseFactory.newEnvironment();
        env.set("org.kie.api.persistence.jpa.EntityManagerFactory", this.ctx.getBean("myEmf"));
        env.set("org.kie.transaction.TransactionManager", (Object)txManager);
        env.set("org.kie.Globals", (Object)new MapGlobalResolver());
        env.set("org.kie.api.marshalling.ObjectMarshallingStrategies", (Object)new ObjectMarshallingStrategy[]{new JPAPlaceholderResolverStrategy(env), new SerializablePlaceholderResolverStrategy((ObjectMarshallingStrategyAcceptor)ClassObjectMarshallingStrategyAcceptor.DEFAULT)});
        final KieStoreServices kstore = (KieStoreServices)this.ctx.getBean("kstore1");
        final KieBase kbRollback = (KieBase)this.ctx.getBean("drl_persistence_rb");
        TransactionTemplate txTemplate = new TransactionTemplate(txManager);
        final KieSession ksession = (KieSession)txTemplate.execute(new TransactionCallback(){

            public Object doInTransaction(TransactionStatus status) {
                KieSession kNewSession = kstore.newKieSession(kbRollback, null, env);
                kNewSession.setGlobal("list", (Object)list);
                kNewSession.insert((Object)1);
                kNewSession.insert((Object)2);
                return kNewSession;
            }
        });
        int sessionId = ksession.getId();
        txTemplate = new TransactionTemplate(txManager);
        txTemplate.execute(new TransactionCallback(){

            public Object doInTransaction(TransactionStatus status) {
                ksession.insert((Object)3);
                status.setRollbackOnly();
                return null;
            }
        });
        txTemplate = new TransactionTemplate(txManager);
        txTemplate.execute(new TransactionCallback(){

            public Object doInTransaction(TransactionStatus status) {
                ksession.fireAllRules();
                return null;
            }
        });
        Assert.assertEquals((long)2L, (long)list.size());
        txTemplate = new TransactionTemplate(txManager);
        txTemplate.execute(new TransactionCallback(){

            public Object doInTransaction(TransactionStatus status) {
                ksession.insert((Object)3);
                ksession.insert((Object)4);
                return null;
            }
        });
        txTemplate = new TransactionTemplate(txManager);
        txTemplate.execute(new TransactionCallback(){

            public Object doInTransaction(TransactionStatus status) {
                ksession.insert((Object)5);
                ksession.insert((Object)6);
                status.setRollbackOnly();
                return null;
            }
        });
        txTemplate = new TransactionTemplate(txManager);
        txTemplate.execute(new TransactionCallback(){

            public Object doInTransaction(TransactionStatus status) {
                ksession.fireAllRules();
                return null;
            }
        });
        Assert.assertEquals((long)4L, (long)list.size());
        ksession.dispose();
        StatefulKnowledgeSession ksession2 = JPAKnowledgeService.loadStatefulKnowledgeSession((int)sessionId, (KieBase)kbRollback, null, (Environment)env);
        txTemplate = new TransactionTemplate(txManager);
        txTemplate.execute(new TransactionCallback((KieSession)ksession2, list){
            final /* synthetic */ KieSession val$ksession2;
            final /* synthetic */ List val$list;
            {
                this.val$ksession2 = kieSession;
                this.val$list = list;
            }

            public Object doInTransaction(TransactionStatus status) {
                this.val$ksession2.setGlobal("list", (Object)this.val$list);
                this.val$ksession2.insert((Object)7);
                this.val$ksession2.insert((Object)8);
                return null;
            }
        });
        txTemplate.execute(new TransactionCallback((KieSession)ksession2){
            final /* synthetic */ KieSession val$ksession2;
            {
                this.val$ksession2 = kieSession;
            }

            public Object doInTransaction(TransactionStatus status) {
                this.val$ksession2.fireAllRules();
                return null;
            }
        });
        Assert.assertEquals((long)6L, (long)list.size());
    }

    @Test
    public void testPersistenceVariables() throws NamingException, NotSupportedException, SystemException, IllegalStateException, RollbackException, HeuristicMixedException, HeuristicRollbackException {
        MyEntity myEntity = new MyEntity("This is a test Entity with annotation in fields");
        MyEntityMethods myEntityMethods = new MyEntityMethods("This is a test Entity with annotations in methods");
        MyEntityOnlyFields myEntityOnlyFields = new MyEntityOnlyFields("This is a test Entity with annotations in fields and without accesors methods");
        MyVariableSerializable myVariableSerializable = new MyVariableSerializable("This is a test SerializableObject");
        EntityManager em = ((EntityManagerFactory)this.ctx.getBean("myEmf")).createEntityManager();
        em.getTransaction().begin();
        em.persist((Object)myEntity);
        em.persist((Object)myEntityMethods);
        em.persist((Object)myEntityOnlyFields);
        em.getTransaction().commit();
        em.close();
        log.info("---> get bean jpaSingleSessionCommandService");
        KieSession service = (KieSession)this.ctx.getBean("jpaSingleSessionCommandService2");
        int sessionId = service.getId();
        log.info("---> created SingleSessionCommandService id: " + sessionId);
        log.info("### Starting process ###");
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("x", "SomeString");
        parameters.put("y", myEntity);
        parameters.put("m", myEntityMethods);
        parameters.put("f", myEntityOnlyFields);
        parameters.put("z", myVariableSerializable);
        WorkflowProcessInstance processInstance = (WorkflowProcessInstance)service.startProcess("com.sample.ruleflow", parameters);
        log.info("Started process instance {}", (Object)processInstance.getId());
        TestWorkItemHandler handler = TestWorkItemHandler.getInstance();
        WorkItem workItem = handler.getWorkItem();
        Assert.assertNotNull((Object)workItem);
        service.dispose();
        EntityManagerFactory emf = (EntityManagerFactory)this.ctx.getBean("myEmf");
        log.info("### Retrieving process instance ###");
        Environment env = KnowledgeBaseFactory.newEnvironment();
        env.set("org.kie.api.persistence.jpa.EntityManagerFactory", (Object)emf);
        env.set("org.kie.transaction.TransactionManager", this.ctx.getBean("txManager"));
        env.set("org.kie.api.marshalling.ObjectMarshallingStrategies", (Object)new ObjectMarshallingStrategy[]{new SerializablePlaceholderResolverStrategy((ObjectMarshallingStrategyAcceptor)ClassObjectMarshallingStrategyAcceptor.DEFAULT)});
        KieStoreServices kstore = (KieStoreServices)this.ctx.getBean("kstore1");
        KieBase kbase1 = (KieBase)this.ctx.getBean("drl_persistence");
        service = kstore.loadKieSession(sessionId, kbase1, null, env);
        processInstance = (WorkflowProcessInstance)service.getProcessInstance(processInstance.getId());
        Assert.assertNotNull((Object)processInstance);
        Assert.assertNotNull((Object)processInstance);
        Assert.assertEquals((Object)"SomeString", (Object)processInstance.getVariable("x"));
        Assert.assertEquals((Object)"This is a test Entity with annotation in fields", (Object)((MyEntity)processInstance.getVariable("y")).getTest());
        Assert.assertEquals((Object)"This is a test Entity with annotations in methods", (Object)((MyEntityMethods)processInstance.getVariable("m")).getTest());
        Assert.assertEquals((Object)"This is a test Entity with annotations in fields and without accesors methods", (Object)((MyEntityOnlyFields)processInstance.getVariable((String)"f")).test);
        Assert.assertEquals((Object)"This is a test SerializableObject", (Object)((MyVariableSerializable)processInstance.getVariable("z")).getText());
        Assert.assertNull((Object)processInstance.getVariable("a"));
        Assert.assertNull((Object)processInstance.getVariable("b"));
        Assert.assertNull((Object)processInstance.getVariable("c"));
        service.dispose();
    }
}

