/*
 * Decompiled with CFR 0.152.
 */
package org.kie.spring.tests.annotations;

import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kie.api.builder.ReleaseId;
import org.kie.api.runtime.KieContainer;
import org.kie.spring.beans.annotations.KContainerBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class KContainerInjectionTest {
    static ApplicationContext context = null;

    @BeforeClass
    public static void setup() {
        context = new ClassPathXmlApplicationContext("org/kie/spring/annotations/kcontainer-tests.xml");
    }

    @Test
    public void testContext() throws Exception {
        Assert.assertNotNull((Object)context);
    }

    @Test
    public void testKContainer() throws Exception {
        KContainerBean sampleBean = (KContainerBean)context.getBean("sampleBean");
        Assert.assertNotNull((Object)sampleBean);
        Assert.assertNotNull((Object)sampleBean.getKieContainer());
        Assert.assertTrue((boolean)(sampleBean.getKieContainer() instanceof KieContainer));
        ReleaseId releaseId = sampleBean.getKieContainer().getReleaseId();
        Assert.assertTrue((boolean)"kie-spring".equalsIgnoreCase(releaseId.getArtifactId()));
    }

    @Test
    public void testSetterKContainer() throws Exception {
        KContainerBean sampleBean = (KContainerBean)context.getBean("sampleBean");
        Assert.assertNotNull((Object)sampleBean);
        Assert.assertNotNull((Object)sampleBean.getKieContainer2());
        Assert.assertTrue((boolean)(sampleBean.getKieContainer2() instanceof KieContainer));
        ReleaseId releaseId = sampleBean.getKieContainer2().getReleaseId();
        Assert.assertTrue((boolean)"kie-spring".equalsIgnoreCase(releaseId.getArtifactId()));
    }

    @AfterClass
    public static void tearDown() {
    }
}

