/*
 * Decompiled with CFR 0.152.
 */
package org.kie.spring.jbpm;

import java.lang.reflect.Field;
import java.util.List;
import junit.framework.Assert;
import org.drools.core.command.impl.CommandBasedStatefulKnowledgeSession;
import org.drools.persistence.SingleSessionCommandService;
import org.jbpm.process.audit.AuditLogService;
import org.jbpm.process.audit.ProcessInstanceLog;
import org.junit.Test;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.task.TaskService;
import org.kie.api.task.model.TaskSummary;
import org.kie.spring.jbpm.AbstractJbpmSpringTest;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class EntityManagerFactorySpringJpaTxManagerTest
extends AbstractJbpmSpringTest {
    @Test
    public void testSpringWithJpa() throws Exception {
        this.context = new ClassPathXmlApplicationContext("jbpm/jpa/jpa-spring.xml");
        RuntimeManager manager = (RuntimeManager)this.context.getBean("runtimeManager");
        RuntimeEngine engine = manager.getRuntimeEngine(null);
        KieSession ksession = engine.getKieSession();
        TaskService taskService = engine.getTaskService();
        this.validatePessimisticLockingUse(ksession);
        ProcessInstance processInstance = ksession.startProcess("com.sample.bpmn.hello");
        System.out.println("Process started");
        AuditLogService logService = (AuditLogService)this.context.getBean("logService");
        ProcessInstanceLog log = logService.findProcessInstance(processInstance.getId());
        Assert.assertNotNull((Object)log);
        List tasks = taskService.getTasksAssignedAsPotentialOwner("john", "en-UK");
        System.out.println("Found " + tasks.size() + " task(s) for user 'john'");
        Assert.assertEquals((int)1, (int)tasks.size());
        long taskId = ((TaskSummary)tasks.get(0)).getId();
        taskService.start(taskId, "john");
        taskService.complete(taskId, "john", null);
        tasks = taskService.getTasksAssignedAsPotentialOwner("mary", "en-UK");
        System.out.println("Found " + tasks.size() + " task(s) for user 'mary'");
        Assert.assertEquals((int)1, (int)tasks.size());
        taskId = ((TaskSummary)tasks.get(0)).getId();
        taskService.start(taskId, "mary");
        taskService.complete(taskId, "mary", null);
        processInstance = ksession.getProcessInstance(processInstance.getId());
        Assert.assertNull((Object)processInstance);
        System.out.println("Process instance completed");
    }

    private void validatePessimisticLockingUse(KieSession ksession) throws Exception {
        CommandBasedStatefulKnowledgeSession cmdBasedKsession = (CommandBasedStatefulKnowledgeSession)ksession;
        SingleSessionCommandService sscs = (SingleSessionCommandService)cmdBasedKsession.getCommandService();
        Field envField = SingleSessionCommandService.class.getDeclaredField("env");
        envField.setAccessible(true);
        Environment env = (Environment)envField.get(sscs);
        Boolean pessLocking = (Boolean)env.get("org.kie.api.persistence.pessimistic");
        Assert.assertNotNull((String)"Pessimistic locking not set in the environment: null object", (Object)pessLocking);
        Assert.assertTrue((String)"Pessimistic locking not set in the environment: null object", (boolean)pessLocking);
    }
}

