/*
 * Decompiled with CFR 0.152.
 */
package org.kie.spring.jbpm;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.naming.InitialContext;
import javax.transaction.UserTransaction;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jbpm.process.audit.AuditLogService;
import org.jbpm.process.audit.ProcessInstanceLog;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.task.TaskService;
import org.kie.api.task.model.Status;
import org.kie.api.task.model.TaskSummary;
import org.kie.internal.query.QueryParameterIdentifiers;
import org.kie.internal.task.api.InternalTaskService;
import org.kie.spring.jbpm.AbstractJbpmSpringTest;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.jta.JtaTransactionManager;
import org.springframework.transaction.support.DefaultTransactionDefinition;

public class JTAEntityManagerFactorySpringTest
extends AbstractJbpmSpringTest {
    @Test
    public void testSpringWithJTAAndEMF() throws Exception {
        this.context = new ClassPathXmlApplicationContext("jbpm/jta-emf/jta-emf-spring.xml");
        RuntimeManager manager = (RuntimeManager)this.context.getBean("runtimeManager");
        RuntimeEngine engine = manager.getRuntimeEngine(null);
        KieSession ksession = engine.getKieSession();
        TaskService taskService = engine.getTaskService();
        ProcessInstance processInstance = ksession.startProcess("com.sample.bpmn.hello");
        System.out.println("Process started");
        AuditLogService logService = (AuditLogService)this.context.getBean("logService");
        ProcessInstanceLog log = logService.findProcessInstance(processInstance.getId());
        Assert.assertNotNull((Object)log);
        List tasks = taskService.getTasksAssignedAsPotentialOwner("john", "en-UK");
        System.out.println("Found " + tasks.size() + " task(s) for user 'john'");
        Assert.assertEquals((long)1L, (long)tasks.size());
        long taskId = ((TaskSummary)tasks.get(0)).getId();
        taskService.start(taskId, "john");
        taskService.complete(taskId, "john", null);
        tasks = taskService.getTasksAssignedAsPotentialOwner("mary", "en-UK");
        System.out.println("Found " + tasks.size() + " task(s) for user 'mary'");
        Assert.assertEquals((long)1L, (long)tasks.size());
        taskId = ((TaskSummary)tasks.get(0)).getId();
        taskService.start(taskId, "mary");
        taskService.complete(taskId, "mary", null);
        processInstance = ksession.getProcessInstance(processInstance.getId());
        Assert.assertNull((Object)processInstance);
        System.out.println("Process instance completed");
    }

    @Test
    public void testSpringWithJTAAndEMFwithRollback() throws Exception {
        this.context = new ClassPathXmlApplicationContext("jbpm/jta-emf/jta-emf-spring.xml");
        RuntimeManager manager = (RuntimeManager)this.context.getBean("runtimeManager");
        RuntimeEngine engine = manager.getRuntimeEngine(null);
        KieSession ksession = engine.getKieSession();
        TaskService taskService = engine.getTaskService();
        AuditLogService logService = (AuditLogService)this.context.getBean("logService");
        UserTransaction ut = (UserTransaction)new InitialContext().lookup("java:comp/UserTransaction");
        ut.begin();
        ProcessInstance processInstance = ksession.startProcess("com.sample.bpmn.hello");
        long processInstanceId = processInstance.getId();
        ut.rollback();
        processInstance = ksession.getProcessInstance(processInstanceId);
        if (processInstance != null) {
            throw new IllegalArgumentException("Process instance not rolled back");
        }
        System.out.println("Process instance rolled back");
        List tasks = taskService.getTasksAssignedAsPotentialOwner("john", "en-UK");
        System.out.println("Found " + tasks.size() + " task(s) for user 'john'");
        Assert.assertEquals((long)0L, (long)tasks.size());
        ProcessInstanceLog log = logService.findProcessInstance(processInstanceId);
        Assert.assertNull((Object)log);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSpringWithJTAAndEMFwithUserTransaction() throws Exception {
        this.context = new ClassPathXmlApplicationContext("jbpm/jta-emf/tx-jta-emf-spring.xml");
        RuntimeManager manager = (RuntimeManager)this.context.getBean("runtimeManager");
        RuntimeEngine engine = manager.getRuntimeEngine(null);
        KieSession ksession = engine.getKieSession();
        TaskService taskService = engine.getTaskService();
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("owner", "john");
        JtaTransactionManager jtaTxm = (JtaTransactionManager)this.context.getBean("jbpmTxManager");
        TransactionStatus ut = null;
        ut = this.beginTransaction(jtaTxm);
        ProcessInstance processInstance = ksession.startProcess("expense", parameters);
        this.executeTasksByProcessByTaskName(processInstance.getId(), "create", taskService);
        jtaTxm.commit(ut);
        ut = this.beginTransaction(jtaTxm);
        this.executeTasksByProcessByTaskName(processInstance.getId(), "edit", taskService);
        jtaTxm.commit(ut);
        ut = this.beginTransaction(jtaTxm);
        this.executeTasksByProcessByTaskName(processInstance.getId(), "edit", taskService);
        jtaTxm.commit(ut);
        ut = this.beginTransaction(jtaTxm);
        this.executeTasksByProcessByTaskName(processInstance.getId(), "edit", taskService);
        jtaTxm.commit(ut);
        ut = this.beginTransaction(jtaTxm);
        this.executeTasksByProcessByTaskName(processInstance.getId(), "delete", taskService);
        jtaTxm.commit(ut);
    }

    private TransactionStatus beginTransaction(JtaTransactionManager jtaTxm) throws Exception {
        DefaultTransactionDefinition def = new DefaultTransactionDefinition();
        TransactionStatus status = jtaTxm.getTransaction((TransactionDefinition)def);
        return status;
    }

    private void executeTasksByProcessByTaskName(long processId, String taskName, TaskService taskService) {
        HashMap<String, List<Long>> parameters = new HashMap<String, List<Long>>();
        parameters.put(QueryParameterIdentifiers.PROCESS_INSTANCE_ID_LIST, Arrays.asList(processId));
        parameters.put(QueryParameterIdentifiers.TASK_STATUS_LIST, Arrays.asList(Status.Ready, Status.Created, Status.Reserved));
        List tasks = ((InternalTaskService)taskService).getTasksByVariousFields("john", parameters, false);
        TaskSummary task = null;
        for (TaskSummary t : tasks) {
            if (!t.getName().equalsIgnoreCase(taskName)) continue;
            task = t;
            break;
        }
        Assert.assertThat(task, (Matcher)CoreMatchers.notNullValue(TaskSummary.class));
        taskService.start(task.getId().longValue(), "john");
        taskService.complete(task.getId().longValue(), "john", null);
    }
}

