/*
 * Decompiled with CFR 0.152.
 */
package org.kie.spring.jbpm;

import java.util.List;
import javax.persistence.EntityManager;
import junit.framework.Assert;
import org.jbpm.process.audit.AuditLogService;
import org.jbpm.process.audit.ProcessInstanceLog;
import org.junit.Test;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.Context;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.task.TaskService;
import org.kie.api.task.model.TaskSummary;
import org.kie.internal.runtime.manager.context.ProcessInstanceIdContext;
import org.kie.spring.jbpm.AbstractJbpmSpringTest;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.AbstractPlatformTransactionManager;
import org.springframework.transaction.support.DefaultTransactionDefinition;

public class LocalEntityManagerSpringTest
extends AbstractJbpmSpringTest {
    @Test
    public void testSpringWithJTAAndEM() throws Exception {
        this.context = new ClassPathXmlApplicationContext("jbpm/local-em/local-em-spring.xml");
        EntityManager em = (EntityManager)this.context.getBean("jbpmEM");
        List sessions = em.createQuery("from SessionInfo").getResultList();
        Assert.assertNotNull((Object)sessions);
        Assert.assertEquals((int)0, (int)sessions.size());
        AbstractPlatformTransactionManager aptm = (AbstractPlatformTransactionManager)this.context.getBean("jbpmTxManager");
        RuntimeManager manager = (RuntimeManager)this.context.getBean("runtimeManager");
        sessions = em.createQuery("from SessionInfo").getResultList();
        Assert.assertNotNull((Object)sessions);
        Assert.assertEquals((int)0, (int)sessions.size());
        RuntimeEngine engine = manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get());
        KieSession ksession = engine.getKieSession();
        TaskService taskService = engine.getTaskService();
        ProcessInstance processInstance = ksession.startProcess("com.sample.bpmn.hello");
        System.out.println("Process started");
        AuditLogService logService = (AuditLogService)this.context.getBean("logService");
        DefaultTransactionDefinition def = new DefaultTransactionDefinition();
        TransactionStatus status = aptm.getTransaction((TransactionDefinition)def);
        ProcessInstanceLog log = logService.findProcessInstance(processInstance.getId());
        aptm.commit(status);
        Assert.assertNotNull((Object)log);
        List tasks = taskService.getTasksAssignedAsPotentialOwner("john", "en-UK");
        System.out.println("Found " + tasks.size() + " task(s) for user 'john'");
        Assert.assertEquals((int)1, (int)tasks.size());
        long taskId = ((TaskSummary)tasks.get(0)).getId();
        taskService.start(taskId, "john");
        taskService.complete(taskId, "john", null);
        tasks = taskService.getTasksAssignedAsPotentialOwner("mary", "en-UK");
        System.out.println("Found " + tasks.size() + " task(s) for user 'mary'");
        Assert.assertEquals((int)1, (int)tasks.size());
        taskId = ((TaskSummary)tasks.get(0)).getId();
        taskService.start(taskId, "mary");
        taskService.complete(taskId, "mary", null);
        processInstance = ksession.getProcessInstance(processInstance.getId());
        Assert.assertNull((Object)processInstance);
        System.out.println("Process instance completed");
    }

    @Test
    public void testSpringWithJTAAndEMwithRollback() throws Exception {
        this.context = new ClassPathXmlApplicationContext("jbpm/local-em/local-em-spring.xml");
        AbstractPlatformTransactionManager aptm = (AbstractPlatformTransactionManager)this.context.getBean("jbpmTxManager");
        RuntimeManager manager = (RuntimeManager)this.context.getBean("runtimeManager");
        RuntimeEngine engine = manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get());
        KieSession ksession = engine.getKieSession();
        TaskService taskService = engine.getTaskService();
        AuditLogService logService = (AuditLogService)this.context.getBean("logService");
        DefaultTransactionDefinition def = new DefaultTransactionDefinition();
        TransactionStatus status = aptm.getTransaction((TransactionDefinition)def);
        ProcessInstance processInstance = ksession.startProcess("com.sample.bpmn.hello");
        long processInstanceId = processInstance.getId();
        aptm.rollback(status);
        processInstance = ksession.getProcessInstance(processInstanceId);
        if (processInstance != null) {
            throw new IllegalArgumentException("Process instance not rolled back");
        }
        System.out.println("Process instance rolled back");
        List tasks = taskService.getTasksAssignedAsPotentialOwner("john", "en-UK");
        System.out.println("Found " + tasks.size() + " task(s) for user 'john'");
        Assert.assertEquals((int)0, (int)tasks.size());
        def = new DefaultTransactionDefinition();
        status = aptm.getTransaction((TransactionDefinition)def);
        ProcessInstanceLog log = logService.findProcessInstance(processInstanceId);
        aptm.commit(status);
        Assert.assertNull((Object)log);
    }
}

