/*
 * Decompiled with CFR 0.152.
 */
package org.kie.spring.jbpm;

import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import javax.persistence.EntityManagerFactory;
import junit.framework.Assert;
import org.jbpm.process.audit.AuditLogService;
import org.jbpm.process.audit.ProcessInstanceLog;
import org.jbpm.runtime.manager.impl.RuntimeEnvironmentBuilder;
import org.jbpm.services.task.identity.JBossUserGroupCallbackImpl;
import org.junit.Test;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeEnvironment;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.manager.RuntimeManagerFactory;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.task.TaskService;
import org.kie.api.task.UserGroupCallback;
import org.kie.api.task.model.TaskSummary;
import org.kie.internal.io.ResourceFactory;
import org.kie.internal.runtime.manager.context.EmptyContext;
import org.kie.spring.jbpm.AbstractJbpmSpringTest;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.AbstractPlatformTransactionManager;
import org.springframework.transaction.support.DefaultTransactionDefinition;

public class LocalEntityManagerFactorySpringLaneTest
extends AbstractJbpmSpringTest {
    @Test
    public void testSpringWithJTAAndEMF() throws Exception {
        this.context = new ClassPathXmlApplicationContext("jbpm/jpa-local-lane/jpa-spring.xml");
        EntityManagerFactory emf = (EntityManagerFactory)this.context.getBean("jbpmEMF");
        AbstractPlatformTransactionManager aptm = (AbstractPlatformTransactionManager)this.context.getBean("jbpmTxManager");
        Properties auth = new Properties();
        auth.setProperty("max", "Standard");
        JBossUserGroupCallbackImpl userGroupCallback = new JBossUserGroupCallbackImpl(auth);
        org.kie.internal.runtime.manager.RuntimeEnvironment environment = RuntimeEnvironmentBuilder.getDefault().entityManagerFactory((Object)emf).userGroupCallback((UserGroupCallback)userGroupCallback).addAsset(ResourceFactory.newClassPathResource((String)"jbpm/processes/sample1.bpmn2"), ResourceType.BPMN2).addEnvironmentEntry("org.kie.transaction.TransactionManager", (Object)aptm).get();
        RuntimeManager manager = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager((RuntimeEnvironment)environment);
        RuntimeEngine engine = manager.getRuntimeEngine(EmptyContext.get());
        KieSession ksession = engine.getKieSession();
        TaskService taskService = engine.getTaskService();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("userid", "max");
        ProcessInstance processInstance = ksession.startProcess("agu.samples.sample1", params);
        AuditLogService logService = (AuditLogService)this.context.getBean("logService");
        DefaultTransactionDefinition def = new DefaultTransactionDefinition();
        TransactionStatus status = aptm.getTransaction((TransactionDefinition)def);
        ProcessInstanceLog log = logService.findProcessInstance(processInstance.getId());
        Assert.assertNotNull((Object)log);
        aptm.commit(status);
        List tasks = taskService.getTasksOwned("max", "en-UK");
        System.out.println("Found " + tasks.size() + " task(s) for user 'max'");
        long taskId = ((TaskSummary)tasks.get(0)).getId();
        taskService.start(taskId, "max");
        taskService.complete(taskId, "max", null);
        tasks = taskService.getTasksAssignedAsPotentialOwner("max", "en-UK");
        System.out.println("Found " + tasks.size() + " task(s) for user 'max'");
        taskId = ((TaskSummary)tasks.get(0)).getId();
        taskService.start(taskId, "max");
        taskService.complete(taskId, "max", null);
        processInstance = ksession.getProcessInstance(processInstance.getId());
        Assert.assertNull((Object)processInstance);
        System.out.println("Process instance completed");
    }
}

