/*
 * Decompiled with CFR 0.152.
 */
package org.kie.spring.tests;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.core.util.FileManager;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.KieScanner;
import org.kie.api.builder.ReleaseId;
import org.kie.api.builder.model.KieBaseModel;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.api.builder.model.KieSessionModel;
import org.kie.api.conf.EqualityBehaviorOption;
import org.kie.api.conf.EventProcessingOption;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.conf.ClockTypeOption;
import org.kie.scanner.MavenRepository;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class KieSpringScannerTest {
    static ApplicationContext context = null;
    private File kPom;
    private ReleaseId releaseId;
    private FileManager fileManager;
    private final int FIRST_VALUE = 5;
    private final int SECOND_VALUE = 10;

    @Test
    public void testSpringKieScanner() throws Exception {
        KieServices ks = KieServices.Factory.get();
        MavenRepository repository = this.createAndDeployModule(ks);
        this.createSpringContext();
        this.lookupNamedKieBase();
        this.lookupReleaseId();
        this.lookupReleaseIdScanner();
        this.checkForValue(5);
        this.redeployModule(repository, ks);
        KieScanner releaseIdScanner = (KieScanner)context.getBean("spring-scanner-releaseId#scanner", KieScanner.class);
        releaseIdScanner.scanNow();
        this.checkForValue(10);
        ks.getRepository().removeKieModule(this.releaseId);
    }

    protected MavenRepository createAndDeployModule(KieServices ks) throws IOException {
        this.fileManager = new FileManager();
        this.fileManager.setUp();
        this.releaseId = KieServices.Factory.get().newReleaseId("org.kie.spring", "spring-scanner-test", "1.0-SNAPSHOT");
        this.kPom = this.createKPom(this.releaseId);
        MavenRepository repository = MavenRepository.getMavenRepository();
        InternalKieModule kJar1 = this.createKieJarWithClass(ks, this.releaseId, 5);
        repository.deployArtifact(this.releaseId, kJar1, this.kPom);
        return repository;
    }

    protected void createSpringContext() throws Exception {
        context = new ClassPathXmlApplicationContext("org/kie/spring/kie-scanner.xml");
        Assert.assertNotNull((Object)context);
    }

    protected void lookupNamedKieBase() throws Exception {
        KieBase kieBase = (KieBase)context.getBean("KBase1", KieBase.class);
        Assert.assertNotNull((Object)kieBase);
    }

    protected void lookupReleaseId() throws Exception {
        ReleaseId releaseId = (ReleaseId)context.getBean("spring-scanner-releaseId", ReleaseId.class);
        Assert.assertNotNull((Object)releaseId);
    }

    protected void lookupReleaseIdScanner() throws Exception {
        KieScanner releaseIdScanner = (KieScanner)context.getBean("spring-scanner-releaseId#scanner", KieScanner.class);
        Assert.assertNotNull((Object)releaseIdScanner);
    }

    protected void redeployModule(MavenRepository repository, KieServices ks) throws IOException {
        InternalKieModule kJar2 = this.createKieJarWithClass(ks, this.releaseId, 10);
        repository.deployArtifact(this.releaseId, kJar2, this.kPom);
    }

    protected void checkForValue(int value) {
        ArrayList list = new ArrayList();
        KieBase kieBase = (KieBase)context.getBean("KBase1", KieBase.class);
        KieSession ksession = kieBase.newKieSession();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        ksession.dispose();
        Assert.assertTrue((String)("Expected:<" + value + "> but was:<" + list.get(0) + ">"), ((Integer)list.get(0) == value ? 1 : 0) != 0);
    }

    protected InternalKieModule createKieJarWithClass(KieServices ks, ReleaseId releaseId, int value) throws IOException {
        KieFileSystem kfs = this.createKieFileSystemWithKProject(ks, false);
        kfs.writePomXML(this.getPom(releaseId, new ReleaseId[0]));
        kfs.write("src/main/resources/KBase1/rule1.drl", this.createDRL(value));
        KieBuilder kieBuilder = ks.newKieBuilder(kfs);
        Assert.assertTrue((String)"", (boolean)kieBuilder.buildAll().getResults().getMessages().isEmpty());
        return (InternalKieModule)kieBuilder.getKieModule();
    }

    protected KieFileSystem createKieFileSystemWithKProject(KieServices ks, boolean isdefault) {
        KieModuleModel kproj = ks.newKieModuleModel();
        KieBaseModel kieBaseModel1 = kproj.newKieBaseModel("KBase1").setDefault(isdefault).setEqualsBehavior(EqualityBehaviorOption.EQUALITY).setEventProcessingMode(EventProcessingOption.STREAM);
        KieSessionModel ksession1 = kieBaseModel1.newKieSessionModel("KSession1").setDefault(isdefault).setType(KieSessionModel.KieSessionType.STATEFUL).setClockType(ClockTypeOption.get((String)"realtime"));
        KieFileSystem kfs = ks.newKieFileSystem();
        kfs.writeKModuleXML(kproj.toXML());
        return kfs;
    }

    protected File createKPom(ReleaseId releaseId) throws IOException {
        File pomFile = this.fileManager.newFile("pom.xml");
        this.fileManager.write(pomFile, this.getPom(releaseId, new ReleaseId[0]));
        return pomFile;
    }

    protected String getPom(ReleaseId releaseId, ReleaseId ... dependencies) {
        String pom = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<project xmlns=\"http://maven.apache.org/POM/4.0.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/maven-v4_0_0.xsd\">\n  <modelVersion>4.0.0</modelVersion>\n\n  <groupId>" + releaseId.getGroupId() + "</groupId>\n" + "  <artifactId>" + releaseId.getArtifactId() + "</artifactId>\n" + "  <version>" + releaseId.getVersion() + "</version>\n" + "\n";
        if (dependencies != null && dependencies.length > 0) {
            pom = pom + "<dependencies>\n";
            for (ReleaseId dep : dependencies) {
                pom = pom + "<dependency>\n";
                pom = pom + "  <groupId>" + dep.getGroupId() + "</groupId>\n";
                pom = pom + "  <artifactId>" + dep.getArtifactId() + "</artifactId>\n";
                pom = pom + "  <version>" + dep.getVersion() + "</version>\n";
                pom = pom + "</dependency>\n";
            }
            pom = pom + "</dependencies>\n";
        }
        pom = pom + "</project>";
        return pom;
    }

    protected String createDRL(int value) {
        return "package org.kie.test\nglobal java.util.List list\nrule simple\nwhen\nthen\n   list.add(" + value + ");\n" + "end\n";
    }
}

