/*
 * Decompiled with CFR 0.152.
 */
package org.kie.spring.timer;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.drools.core.base.MapGlobalResolver;
import org.kie.api.KieBase;
import org.kie.api.persistence.jpa.KieStoreServices;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.internal.KnowledgeBaseFactory;
import org.kie.spring.timer.TestWorkItemHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.orm.jpa.JpaTransactionManager;

public class MyDroolsBean {
    private static int timerTriggerCount;
    private static long sessionId;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private EntityManagerFactory emf;
    private KieBase kbase;
    private KieStoreServices kstore;
    private JpaTransactionManager txm;
    private TestWorkItemHandler workItemHandler = new TestWorkItemHandler();

    public void initStartDisposeAndLoadSession() {
        try {
            EntityManager em = this.txm.getEntityManagerFactory().createEntityManager();
            KieSession ksession = this.kstore.newKieSession(this.kbase, null, this.getEnvironment());
            sessionId = ksession.getIdentifier();
            this.logger.info("\n\tSession id: " + sessionId + "\n");
            ksession.getWorkItemManager().registerWorkItemHandler("testWorkItemHandler", (WorkItemHandler)this.workItemHandler);
            ksession.startProcess("timer-flow", null);
            Thread.sleep(4000L);
            ksession.dispose();
        }
        catch (Exception ex) {
            throw new IllegalStateException("The endTheProcess method has been interrupted", ex);
        }
    }

    public static synchronized void incrementTimerTriggerCount() {
        ++timerTriggerCount;
    }

    public static synchronized int getTimerTriggerCount() {
        return timerTriggerCount;
    }

    public void endTheProcess() {
        try {
            KieSession ksession = this.kstore.loadKieSession(Long.valueOf(sessionId), this.kbase, null, this.getEnvironment());
            this.logger.info("\n\nSleeping to check that the timer is still running");
            Thread.sleep(5000L);
            ksession.getWorkItemManager().completeWorkItem(TestWorkItemHandler.getWorkItem().getId(), null);
            this.logger.info("\n\nSleeping to check that the timer is no longer running");
            Thread.sleep(3000L);
            this.logger.info("Ok");
            ksession.dispose();
        }
        catch (InterruptedException ex) {
            throw new IllegalStateException("The endTheProcess method has been interrupted", ex);
        }
    }

    private Environment getEnvironment() {
        Environment environment = KnowledgeBaseFactory.newEnvironment();
        environment.set("org.kie.api.persistence.jpa.EntityManagerFactory", (Object)this.emf);
        environment.set("org.kie.transaction.TransactionManager", (Object)this.txm);
        environment.set("org.kie.Globals", (Object)new MapGlobalResolver());
        return environment;
    }

    public void setEmf(EntityManagerFactory emf) {
        this.emf = emf;
    }

    public void setKbase(KieBase kbase) {
        this.kbase = kbase;
    }

    public void setKstore(KieStoreServices kstore) {
        this.kstore = kstore;
    }

    public void setTxm(JpaTransactionManager txm) {
        this.txm = txm;
    }
}

