/*
 * Decompiled with CFR 0.152.
 */
package org.kie.spring.jbpm;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.task.TaskService;
import org.kie.api.task.model.Status;
import org.kie.api.task.model.TaskSummary;
import org.kie.spring.jbpm.AbstractJbpmSpringTest;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.jta.JtaTransactionManager;
import org.springframework.transaction.support.DefaultTransactionDefinition;

public class ProcessFlowSpringTest
extends AbstractJbpmSpringTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEventBasedGatewayWithUserTransaction() throws Exception {
        this.context = new ClassPathXmlApplicationContext("jbpm/jta-emf/singleton.xml");
        RuntimeManager manager = (RuntimeManager)this.context.getBean("runtimeManager");
        RuntimeEngine engine = manager.getRuntimeEngine(null);
        KieSession ksession = engine.getKieSession();
        TaskService taskService = engine.getTaskService();
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("owner", "john");
        JtaTransactionManager jtaTxm = (JtaTransactionManager)this.context.getBean("jbpmTxManager");
        TransactionStatus ut = null;
        ut = this.beginTransaction(jtaTxm);
        ProcessInstance processInstance = ksession.startProcess("expense", parameters);
        this.executeTasksByProcessByTaskName(processInstance.getId(), "create", taskService);
        jtaTxm.commit(ut);
        ut = this.beginTransaction(jtaTxm);
        this.executeTasksByProcessByTaskName(processInstance.getId(), "edit", taskService);
        jtaTxm.commit(ut);
        ut = this.beginTransaction(jtaTxm);
        this.executeTasksByProcessByTaskName(processInstance.getId(), "edit", taskService);
        jtaTxm.commit(ut);
        ut = this.beginTransaction(jtaTxm);
        this.executeTasksByProcessByTaskName(processInstance.getId(), "edit", taskService);
        jtaTxm.commit(ut);
        ut = this.beginTransaction(jtaTxm);
        this.executeTasksByProcessByTaskName(processInstance.getId(), "delete", taskService);
        jtaTxm.commit(ut);
    }

    private TransactionStatus beginTransaction(JtaTransactionManager jtaTxm) throws Exception {
        DefaultTransactionDefinition def = new DefaultTransactionDefinition();
        TransactionStatus status = jtaTxm.getTransaction((TransactionDefinition)def);
        return status;
    }

    private void executeTasksByProcessByTaskName(long processId, String taskName, TaskService taskService) {
        List<Status> status = Arrays.asList(Status.Ready, Status.Created, Status.Reserved);
        List tasks = taskService.getTasksAssignedAsPotentialOwnerByStatus("john", status, "en-UK");
        TaskSummary task = null;
        for (TaskSummary t : tasks) {
            if (!t.getName().equalsIgnoreCase(taskName)) continue;
            task = t;
            break;
        }
        Assert.assertNotNull(task);
        taskService.start(task.getId().longValue(), "john");
        taskService.complete(task.getId().longValue(), "john", null);
    }
}

