/*
 * Decompiled with CFR 0.152.
 */
package org.kie.spring.jbpm;

import java.util.Arrays;
import java.util.Collection;
import org.jbpm.process.audit.AuditLogService;
import org.jbpm.process.audit.ProcessInstanceLog;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.Context;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.internal.runtime.manager.context.EmptyContext;
import org.kie.internal.runtime.manager.context.ProcessInstanceIdContext;
import org.kie.spring.jbpm.AbstractJbpmSpringTest;
import org.springframework.context.support.ClassPathXmlApplicationContext;

@RunWith(value=Parameterized.class)
public class RuntimeManagerInitNoInitialContextSpringTest
extends AbstractJbpmSpringTest {
    private static String CONTEXT_FACTORY;
    @Parameterized.Parameter(value=0)
    public String contextPath;
    @Parameterized.Parameter(value=1)
    public Context<?> runtimeManagerContext;

    @Parameterized.Parameters(name="{index}: {0}")
    public static Collection<Object[]> contextPath() {
        Object[][] data = new Object[][]{{"jbpm/local-emf/singleton.xml", EmptyContext.get()}, {"jbpm/local-emf/per-process-instance.xml", ProcessInstanceIdContext.get()}, {"jbpm/local-emf/per-request.xml", EmptyContext.get()}};
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void setUp() throws Exception {
        CONTEXT_FACTORY = System.getProperty("java.naming.factory.initial");
        System.setProperty("java.naming.factory.initial", "incorrectFactory");
    }

    @AfterClass
    public static void tearDown() throws Exception {
        if (CONTEXT_FACTORY != null) {
            System.setProperty("java.naming.factory.initial", CONTEXT_FACTORY);
        } else {
            System.clearProperty("java.naming.factory.initial");
        }
    }

    @Test
    public void testSimpleTaskInvocation() throws Exception {
        this.context = new ClassPathXmlApplicationContext(this.contextPath);
        RuntimeManager manager = (RuntimeManager)this.context.getBean("runtimeManager");
        AuditLogService auditLogService = (AuditLogService)this.context.getBean("logService");
        RuntimeEngine engine = manager.getRuntimeEngine(this.runtimeManagerContext);
        KieSession ksession = engine.getKieSession();
        ProcessInstance processInstance = ksession.startProcess("com.sample.bpmn.hello");
        System.out.println("Process started");
        ProcessInstanceLog instanceLog = auditLogService.findProcessInstance(processInstance.getId());
        Assert.assertNotNull((Object)instanceLog);
        Assert.assertEquals((long)1L, (long)instanceLog.getStatus().intValue());
        ksession.abortProcessInstance(processInstance.getId());
        System.out.println("Process instance aborted");
        instanceLog = auditLogService.findProcessInstance(processInstance.getId());
        Assert.assertNotNull((Object)instanceLog);
        Assert.assertEquals((long)3L, (long)instanceLog.getStatus().intValue());
        manager.disposeRuntimeEngine(engine);
    }
}

