/*
 * Decompiled with CFR 0.152.
 */
package org.kie.spring.jbpm;

import java.util.HashMap;
import java.util.List;
import org.jbpm.process.audit.AuditLogService;
import org.jbpm.process.audit.ProcessInstanceLog;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.task.TaskService;
import org.kie.api.task.model.TaskSummary;
import org.kie.internal.runtime.manager.context.EmptyContext;
import org.kie.spring.jbpm.AbstractJbpmSpringTest;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class SwimlaneSpringTest
extends AbstractJbpmSpringTest {
    @Test
    public void testCompleteTaskInSwimlane() throws Exception {
        this.context = new ClassPathXmlApplicationContext("jbpm/usergroup-callback/local-emf-singleton.xml");
        RuntimeManager manager = (RuntimeManager)this.context.getBean("runtimeManager");
        RuntimeEngine engine = manager.getRuntimeEngine(EmptyContext.get());
        KieSession ksession = engine.getKieSession();
        TaskService taskService = engine.getTaskService();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("userid", "max");
        ProcessInstance processInstance = ksession.startProcess("agu.samples.sample1", params);
        AuditLogService logService = (AuditLogService)this.context.getBean("logService");
        ProcessInstanceLog log = logService.findProcessInstance(processInstance.getId());
        Assert.assertNotNull((Object)log);
        List tasks = taskService.getTasksOwned("max", "en-UK");
        System.out.println("Found " + tasks.size() + " task(s) for user 'max'");
        long taskId = ((TaskSummary)tasks.get(0)).getId();
        taskService.start(taskId, "max");
        taskService.complete(taskId, "max", null);
        tasks = taskService.getTasksAssignedAsPotentialOwner("max", "en-UK");
        System.out.println("Found " + tasks.size() + " task(s) for user 'max'");
        taskId = ((TaskSummary)tasks.get(0)).getId();
        taskService.start(taskId, "max");
        taskService.complete(taskId, "max", null);
        processInstance = ksession.getProcessInstance(processInstance.getId());
        Assert.assertNull((Object)processInstance);
        System.out.println("Process instance completed");
    }
}

