/*
 * Decompiled with CFR 0.152.
 */
package org.kie.spring.tests;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.builder.KieScanner;
import org.kie.api.builder.ReleaseId;
import org.kie.api.runtime.KieSession;
import org.kie.scanner.MavenRepository;
import org.kie.spring.tests.AbstractKieSpringDynamicModuleTest;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class KieSpringScannerTest
extends AbstractKieSpringDynamicModuleTest {
    static ApplicationContext context = null;
    private final int SECOND_VALUE = 10;
    protected final int FIRST_VALUE = 5;

    @Test
    public void testSpringKieScanner() throws Exception {
        KieServices ks = KieServices.Factory.get();
        MavenRepository repository = this.createAndInstallModule(ks, 5);
        this.createSpringContext();
        this.lookupNamedKieBase();
        this.lookupReleaseId();
        this.lookupReleaseIdScanner();
        this.checkForValue(5);
        this.reinstallModule(repository, ks);
        KieScanner releaseIdScanner = (KieScanner)context.getBean("spring-scanner-releaseId#scanner", KieScanner.class);
        releaseIdScanner.scanNow();
        this.checkForValue(10);
        ks.getRepository().removeKieModule(this.releaseId);
    }

    protected void createSpringContext() throws Exception {
        context = new ClassPathXmlApplicationContext("org/kie/spring/kie-scanner.xml");
        Assert.assertNotNull((Object)context);
    }

    protected void lookupNamedKieBase() throws Exception {
        KieBase kieBase = (KieBase)context.getBean("KBase1", KieBase.class);
        Assert.assertNotNull((Object)kieBase);
    }

    protected void lookupReleaseId() throws Exception {
        ReleaseId releaseId = (ReleaseId)context.getBean("spring-scanner-releaseId", ReleaseId.class);
        Assert.assertNotNull((Object)releaseId);
    }

    protected void lookupReleaseIdScanner() throws Exception {
        KieScanner releaseIdScanner = (KieScanner)context.getBean("spring-scanner-releaseId#scanner", KieScanner.class);
        Assert.assertNotNull((Object)releaseIdScanner);
    }

    protected void reinstallModule(MavenRepository repository, KieServices ks) throws IOException {
        InternalKieModule kJar2 = this.createKieJarWithClass(ks, this.releaseId, 10);
        File kPom = this.createKPom(this.releaseId);
        repository.installArtifact(this.releaseId, kJar2, kPom);
    }

    protected void checkForValue(int value) {
        ArrayList list = new ArrayList();
        KieBase kieBase = (KieBase)context.getBean("KBase1", KieBase.class);
        KieSession ksession = kieBase.newKieSession();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        ksession.dispose();
        Assert.assertTrue((String)("Expected:<" + value + "> but was:<" + list.get(0) + ">"), ((Integer)list.get(0) == value ? 1 : 0) != 0);
    }
}

