/*
 * Decompiled with CFR 0.152.
 */
package org.kie.spring.jbpm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CountDownLatch;
import javax.persistence.LockTimeoutException;
import javax.persistence.PessimisticLockException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jbpm.process.audit.AuditLogService;
import org.jbpm.process.audit.ProcessInstanceLog;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestRule;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.Context;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.internal.runtime.manager.context.EmptyContext;
import org.kie.spring.jbpm.AbstractJbpmSpringParameterizedTest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.AbstractPlatformTransactionManager;
import org.springframework.transaction.support.DefaultTransactionDefinition;

@RunWith(value=Parameterized.class)
public class PessimisticLockingSpringTest
extends AbstractJbpmSpringParameterizedTest {
    private static final Logger log = LoggerFactory.getLogger(PessimisticLockingSpringTest.class);
    @Rule
    public TestRule watcher = new TestWatcher(){

        protected void starting(Description description) {
            log.debug(">>> " + description.getMethodName() + " <<<");
        }

        protected void finished(Description description) {
            log.debug("<<< DONE >>>");
        }
    };

    @Parameterized.Parameters(name="{index}: {0}")
    public static Collection<Object[]> contextPath() {
        Object[][] data = new Object[][]{{"jbpm/pessimistic-lock/pessimistic-locking-local-em-factory-beans.xml", EmptyContext.get()}, {"jbpm/pessimistic-lock/pessimistic-locking-local-emf-factory-beans.xml", EmptyContext.get()}};
        return Arrays.asList(data);
    }

    public PessimisticLockingSpringTest(String contextPath, Context<?> runtimeManagerContext) {
        super(contextPath, runtimeManagerContext);
    }

    @Test
    public void testPessimisticLock() throws Exception {
        RuntimeManager manager = this.getManager();
        final AbstractPlatformTransactionManager transactionManager = this.getTransactionManager();
        AuditLogService logService = this.getLogService();
        final DefaultTransactionDefinition defTransDefinition = new DefaultTransactionDefinition();
        final ArrayList exceptions = new ArrayList();
        RuntimeEngine engine = this.getEngine();
        final KieSession ksession = this.getKieSession();
        final ProcessInstance processInstance = ksession.startProcess("org.jboss.qa.bpms.HumanTask");
        final ProcessInstanceStatus abortedProcessInstanceStatus = new ProcessInstanceStatus();
        final CountDownLatch txAcquiredSignal = new CountDownLatch(1);
        final CountDownLatch pessLockExceptionSignal = new CountDownLatch(1);
        final CountDownLatch threadsAreDoneLatch = new CountDownLatch(2);
        Thread t1 = new Thread(){

            @Override
            public void run() {
                TransactionStatus status = transactionManager.getTransaction((TransactionDefinition)defTransDefinition);
                log.debug("Attempting to abort to lock process instance for 3 secs ");
                ksession.abortProcessInstance(processInstance.getId());
                txAcquiredSignal.countDown();
                try {
                    pessLockExceptionSignal.await();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                log.debug("Commited process instance aborting after 3 secs");
                transactionManager.commit(status);
                threadsAreDoneLatch.countDown();
            }
        };
        Thread t2 = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    txAcquiredSignal.await();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                log.debug("Trying to get process instance - should fail because process instance is locked or wait until thread 1 finish and return null because process instance is deleted.");
                try {
                    ProcessInstance abortedProcessInstance = ksession.getProcessInstance(processInstance.getId(), true);
                    if (abortedProcessInstance == null) {
                        abortedProcessInstanceStatus.setAbortedProcessInstance(true);
                    }
                    log.debug("Get request worked well");
                }
                catch (Exception e) {
                    log.debug("Get request failed with error {}", (Object)e.getMessage());
                    exceptions.add(e);
                }
                finally {
                    pessLockExceptionSignal.countDown();
                }
                threadsAreDoneLatch.countDown();
            }
        };
        t1.start();
        t2.start();
        threadsAreDoneLatch.await();
        if (abortedProcessInstanceStatus.isAbortedProcessInstance()) {
            Assert.assertEquals((long)0L, (long)exceptions.size());
        } else {
            Assert.assertEquals((long)1L, (long)exceptions.size());
            Assert.assertThat((Object)((Exception)exceptions.get(0)).getClass().getName(), (Matcher)CoreMatchers.anyOf((Matcher)CoreMatchers.equalTo((Object)PessimisticLockException.class.getName()), (Matcher)CoreMatchers.equalTo((Object)LockTimeoutException.class.getName())));
        }
        TransactionStatus status = transactionManager.getTransaction((TransactionDefinition)defTransDefinition);
        ProcessInstanceLog instanceLog = logService.findProcessInstance(processInstance.getId());
        transactionManager.commit(status);
        Assert.assertNotNull((Object)instanceLog);
        Assert.assertEquals((long)3L, (long)instanceLog.getStatus().intValue());
        manager.disposeRuntimeEngine(engine);
    }

    private class ProcessInstanceStatus {
        private boolean abortedProcessInstance = false;

        private ProcessInstanceStatus() {
        }

        public boolean isAbortedProcessInstance() {
            return this.abortedProcessInstance;
        }

        public void setAbortedProcessInstance(boolean abortedProcessInstance) {
            this.abortedProcessInstance = abortedProcessInstance;
        }
    }
}

