/*
 * Decompiled with CFR 0.152.
 */
package org.kie.spring.tests;

import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.StatelessKieSession;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class KieSpringScopeTest {
    static ApplicationContext context = null;

    @BeforeClass
    public static void setup() {
        context = new ClassPathXmlApplicationContext("org/kie/spring/beans-with-scope.xml");
    }

    @Test
    public void testContext() throws Exception {
        Assert.assertNotNull((Object)context);
    }

    @Test
    public void testStatelessPrototypeKieSession() throws Exception {
        StatelessKieSession ksession = (StatelessKieSession)context.getBean("statelessPrototypeSession");
        Assert.assertNotNull((Object)ksession);
        StatelessKieSession anotherKsession = (StatelessKieSession)context.getBean("statelessPrototypeSession");
        Assert.assertNotNull((Object)anotherKsession);
        Assert.assertNotEquals((long)ksession.hashCode(), (long)anotherKsession.hashCode());
    }

    @Test
    public void testStatelessSingletonKieSession() throws Exception {
        StatelessKieSession ksession = (StatelessKieSession)context.getBean("statelessSingletonSession");
        Assert.assertNotNull((Object)ksession);
        StatelessKieSession anotherKsession = (StatelessKieSession)context.getBean("statelessSingletonSession");
        Assert.assertNotNull((Object)anotherKsession);
        Assert.assertEquals((long)ksession.hashCode(), (long)anotherKsession.hashCode());
    }

    @Test
    public void testStatefulSingletonKieSession() throws Exception {
        KieSession ksession = (KieSession)context.getBean("statefulSingletonSession");
        Assert.assertNotNull((Object)ksession);
        KieSession anotherKsession = (KieSession)context.getBean("statefulSingletonSession");
        Assert.assertNotNull((Object)anotherKsession);
        Assert.assertEquals((long)ksession.hashCode(), (long)anotherKsession.hashCode());
    }

    @Test
    public void testStatefulPrototypeKieSession() throws Exception {
        KieSession ksession = (KieSession)context.getBean("statefulPrototypeSession");
        Assert.assertNotNull((Object)ksession);
        KieSession anotherKsession = (KieSession)context.getBean("statefulPrototypeSession");
        Assert.assertNotNull((Object)anotherKsession);
        Assert.assertNotEquals((long)ksession.hashCode(), (long)anotherKsession.hashCode());
    }

    @AfterClass
    public static void tearDown() {
    }
}

