/*
 * Decompiled with CFR 0.152.
 */
package org.kie.spring.tests;

import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.runtime.KieSession;
import org.kie.spring.beans.Person;
import org.kie.spring.beans.annotations.BeanWithReleaseId;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class KieSpringImportKieTest {
    protected static ApplicationContext context = null;

    @BeforeClass
    public static void setup() {
        context = new ClassPathXmlApplicationContext("org/kie/spring/kie-import.xml");
    }

    @Test
    public void testContext() throws Exception {
        Assert.assertNotNull((Object)context);
    }

    @Test
    public void testNamedKieBase() throws Exception {
        KieBase kieBase = (KieBase)context.getBean("kbase1", KieBase.class);
        Assert.assertNotNull((Object)kieBase);
    }

    @Test
    public void testNamedKieSession() throws Exception {
        KieSession kieSession = (KieSession)context.getBean("ksession1", KieSession.class);
        Assert.assertNotNull((Object)kieSession);
    }

    @Test
    public void testRegularPojo() throws Exception {
        Person p = (Person)context.getBean("person", Person.class);
        Assert.assertNotNull((Object)p);
    }

    @Test
    public void testAnnotatedBeanKContainer() throws Exception {
        BeanWithReleaseId bean = (BeanWithReleaseId)context.getBean("annotatedBean", BeanWithReleaseId.class);
        Assert.assertNotNull((Object)bean);
        Assert.assertNotNull((Object)bean.getKieContainer());
    }

    @Test
    public void testAnnotatedBeanKieBase() throws Exception {
        BeanWithReleaseId bean = (BeanWithReleaseId)context.getBean("annotatedBean", BeanWithReleaseId.class);
        Assert.assertNotNull((Object)bean);
        Assert.assertNotNull((Object)bean.getKieBase());
    }

    @Test
    public void testAnnotatedBeanKieSession() throws Exception {
        BeanWithReleaseId bean = (BeanWithReleaseId)context.getBean("annotatedBean", BeanWithReleaseId.class);
        Assert.assertNotNull((Object)bean);
        Assert.assertNotNull((Object)bean.getKieSession());
    }

    @AfterClass
    public static void tearDown() {
    }
}

