/*
 * Decompiled with CFR 0.152.
 */
package org.kie.spring.tests;

import java.util.ArrayList;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.StatelessKieSession;
import org.kie.spring.beans.Person;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class KieSpringCommandsTest {
    static ApplicationContext context = null;

    @BeforeClass
    public static void setup() {
        context = new ClassPathXmlApplicationContext("org/kie/spring/beans-commands.xml");
    }

    @Test
    public void testKieBase() throws Exception {
        KieBase kbase = (KieBase)context.getBean("drl_kiesample3");
        Assert.assertNotNull((Object)kbase);
    }

    @Test
    public void testInsertObject() throws Exception {
        KieSession ksession = (KieSession)context.getBean("ksession2");
        Assert.assertNotNull((Object)ksession);
        Assert.assertEquals((long)1L, (long)ksession.getObjects().size());
        Assert.assertTrue((boolean)(ksession.getObjects().toArray()[0] instanceof Person));
        for (Object object : ksession.getObjects()) {
            if (!(object instanceof Person)) continue;
            Assert.assertFalse((boolean)((Person)object).isHappy());
        }
        ksession.fireAllRules();
        for (Object object : ksession.getObjects()) {
            if (!(object instanceof Person)) continue;
            Assert.assertTrue((boolean)((Person)object).isHappy());
        }
    }

    @Test
    public void testInsertObjectAndFireAll() throws Exception {
        KieSession ksession = (KieSession)context.getBean("ksessionForCommands");
        Assert.assertNotNull((Object)ksession);
        Assert.assertEquals((long)1L, (long)ksession.getObjects().size());
        Assert.assertTrue((boolean)(ksession.getObjects().toArray()[0] instanceof Person));
        for (Object object : ksession.getObjects()) {
            if (!(object instanceof Person)) continue;
            Assert.assertTrue((boolean)((Person)object).isHappy());
        }
    }

    @Test
    public void testStatelessKieSessionWithGlobal() throws Exception {
        StatelessKieSession ksession = (StatelessKieSession)context.getBean("statlessKsessionWithGlobal");
        Assert.assertNotNull((Object)ksession);
        Person person = new Person("HAL2", 42);
        person.setHappy(false);
        ksession.execute((Object)person);
        Assert.assertTrue((boolean)person.isHappy());
    }

    @Test
    public void testStatelessKieSessionWithGlobalExecutingList() throws Exception {
        StatelessKieSession ksession = (StatelessKieSession)context.getBean("statlessKsessionWithGlobal");
        Assert.assertNotNull((Object)ksession);
        ArrayList<Person> persons = new ArrayList<Person>();
        Person person1 = new Person("HAL", 42);
        person1.setHappy(false);
        persons.add(person1);
        Person person2 = new Person("HAL2", 42);
        person2.setHappy(false);
        persons.add(person2);
        ksession.execute(persons);
        Assert.assertTrue((boolean)person1.isHappy());
        Assert.assertTrue((boolean)person2.isHappy());
    }

    @Test
    public void testSetGlobals() throws Exception {
        KieSession ksession = (KieSession)context.getBean("ksessionForCommands");
        Assert.assertNotNull((Object)ksession);
        Assert.assertEquals((long)1L, (long)ksession.getObjects().size());
        Assert.assertTrue((boolean)(ksession.getObjects().toArray()[0] instanceof Person));
        Person p1 = (Person)ksession.getObjects().toArray()[0];
        Assert.assertNotNull((Object)p1);
        for (Object object : ksession.getObjects()) {
            if (!(object instanceof Person)) continue;
            Assert.assertTrue((boolean)((Person)object).isHappy());
        }
        Object list = ksession.getGlobal("persons");
        Assert.assertNotNull((Object)list);
        Assert.assertTrue((boolean)(list instanceof ArrayList));
        Assert.assertEquals((long)1L, (long)((ArrayList)list).size());
        Person p = (Person)((ArrayList)list).get(0);
        Assert.assertNotNull((Object)p);
        Assert.assertEquals((Object)p, (Object)p1);
    }

    @AfterClass
    public static void tearDown() {
    }
}

