/*
 * Decompiled with CFR 0.152.
 */
package org.kie.spring.tests.persistence;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CyclicBarrier;
import org.drools.compiler.builder.impl.KnowledgeBuilderImpl;
import org.drools.core.util.DroolsStreamUtils;
import org.h2.tools.DeleteDbFiles;
import org.h2.tools.Server;
import org.jbpm.compiler.ProcessBuilderImpl;
import org.jbpm.process.core.Work;
import org.jbpm.process.core.impl.WorkImpl;
import org.jbpm.process.core.timer.Timer;
import org.jbpm.ruleflow.core.RuleFlowProcess;
import org.jbpm.ruleflow.instance.RuleFlowProcessInstance;
import org.jbpm.workflow.core.DroolsAction;
import org.jbpm.workflow.core.impl.ConnectionImpl;
import org.jbpm.workflow.core.impl.DroolsConsequenceAction;
import org.jbpm.workflow.core.node.ActionNode;
import org.jbpm.workflow.core.node.EndNode;
import org.jbpm.workflow.core.node.StartNode;
import org.jbpm.workflow.core.node.SubProcessNode;
import org.jbpm.workflow.core.node.TimerNode;
import org.jbpm.workflow.core.node.WorkItemNode;
import org.jbpm.workflow.instance.node.SubProcessNodeInstance;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.definition.KiePackage;
import org.kie.api.definition.process.Node;
import org.kie.api.definition.process.Process;
import org.kie.api.persistence.jpa.KieStoreServices;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.WorkItem;
import org.kie.spring.beans.persistence.TestWorkItemHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class JPASingleSessionCommandServiceFactoryTest {
    private static String TMPDIR = System.getProperty("java.io.tmpdir");
    private static final Logger log = LoggerFactory.getLogger(JPASingleSessionCommandServiceFactoryTest.class);
    private static Server h2Server;
    private static ApplicationContext ctx;
    private static CyclicBarrier cyclicBarrier;

    @BeforeClass
    public static void startH2Database() throws Exception {
        DeleteDbFiles.execute((String)"", (String)"DroolsFlow", (boolean)true);
        h2Server = Server.createTcpServer((String[])new String[0]);
        h2Server.start();
        try {
            TMPDIR = JPASingleSessionCommandServiceFactoryTest.class.getResource("/kb_persistence").getFile();
            log.debug("creating: {}", (Object)(TMPDIR + "/processWorkItems.pkg"));
            JPASingleSessionCommandServiceFactoryTest.writePackage(JPASingleSessionCommandServiceFactoryTest.getProcessWorkItems(), new File(TMPDIR + "/processWorkItems.pkg"));
            log.debug("creating: {}", (Object)(TMPDIR + "/processSubProcess.pkg"));
            JPASingleSessionCommandServiceFactoryTest.writePackage(JPASingleSessionCommandServiceFactoryTest.getProcessSubProcess(), new File(TMPDIR + "/processSubProcess.pkg"));
            log.debug("creating: {}", (Object)(TMPDIR + "/processTimer.pkg"));
            JPASingleSessionCommandServiceFactoryTest.writePackage(JPASingleSessionCommandServiceFactoryTest.getProcessTimer(), new File(TMPDIR + "/processTimer.pkg"));
            log.debug("creating: {}", (Object)(TMPDIR + "/processTimer2.pkg"));
            JPASingleSessionCommandServiceFactoryTest.writePackage(JPASingleSessionCommandServiceFactoryTest.getProcessTimer2(), new File(TMPDIR + "/processTimer2.pkg"));
        }
        catch (Exception e) {
            log.error("can't create packages!", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @AfterClass
    public static void stopH2Database() throws Exception {
        log.debug("stopping database");
        h2Server.stop();
        DeleteDbFiles.execute((String)"", (String)"DroolsFlow", (boolean)true);
    }

    @Before
    public void createSpringContext() {
        try {
            log.debug("creating spring context");
            ctx = new ClassPathXmlApplicationContext("org/kie/spring/persistence/persistence_beans.xml");
        }
        catch (Exception e) {
            log.error("can't create spring context", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @After
    public void close() {
    }

    @Test
    public void testPersistenceWorkItems() throws Exception {
        log.debug("---> get bean jpaSingleSessionCommandService");
        KieBase kbase = (KieBase)ctx.getBean("kb_persistence");
        KieSession service = (KieSession)ctx.getBean("jpaSingleSessionCommandService");
        log.debug("---> create new SingleSessionCommandService");
        long sessionId = service.getIdentifier();
        log.debug("---> created SingleSessionCommandService id: " + sessionId);
        ProcessInstance processInstance = service.startProcess("org.drools.test.TestProcess");
        log.debug("Started process instance {}", (Object)processInstance.getId());
        TestWorkItemHandler handler = TestWorkItemHandler.getInstance();
        WorkItem workItem = handler.getWorkItem();
        Assert.assertNotNull((Object)workItem);
        service.dispose();
        Environment env = KieServices.get().newEnvironment();
        env.set("org.kie.api.persistence.jpa.EntityManagerFactory", ctx.getBean("myEmf"));
        env.set("org.kie.transaction.TransactionManager", ctx.getBean("txManager"));
        KieStoreServices kstore = (KieStoreServices)ctx.getBean("kstore1");
        service = kstore.loadKieSession(Long.valueOf(sessionId), kbase, null, env);
        processInstance = service.getProcessInstance(processInstance.getId());
        Assert.assertNotNull((Object)processInstance);
        service.dispose();
        service = kstore.loadKieSession(Long.valueOf(sessionId), kbase, null, env);
        service.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        workItem = handler.getWorkItem();
        Assert.assertNotNull((Object)workItem);
        service.dispose();
        service = kstore.loadKieSession(Long.valueOf(sessionId), kbase, null, env);
        processInstance = service.getProcessInstance(processInstance.getId());
        Assert.assertNotNull((Object)processInstance);
        service.dispose();
        service = kstore.loadKieSession(Long.valueOf(sessionId), kbase, null, env);
        service.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        workItem = handler.getWorkItem();
        Assert.assertNotNull((Object)workItem);
        service.dispose();
        service = kstore.loadKieSession(Long.valueOf(sessionId), kbase, null, env);
        processInstance = service.getProcessInstance(processInstance.getId());
        service.dispose();
        service = kstore.loadKieSession(Long.valueOf(sessionId), kbase, null, env);
        service.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        workItem = handler.getWorkItem();
        Assert.assertNull((Object)workItem);
        service.dispose();
        service = kstore.loadKieSession(Long.valueOf(sessionId), kbase, null, env);
        processInstance = service.getProcessInstance(processInstance.getId());
        service.dispose();
    }

    @Test
    public void testPersistenceWorkItemsUserTransaction() throws Exception {
        KieBase kbase = (KieBase)ctx.getBean("kb_persistence");
        KieSession service = (KieSession)ctx.getBean("jpaSingleSessionCommandService");
        long sessionId = service.getIdentifier();
        ProcessInstance processInstance = service.startProcess("org.drools.test.TestProcess");
        log.debug("Started process instance {}", (Object)processInstance.getId());
        TestWorkItemHandler handler = TestWorkItemHandler.getInstance();
        WorkItem workItem = handler.getWorkItem();
        Assert.assertNotNull((Object)workItem);
        service.dispose();
        Environment env = KieServices.get().newEnvironment();
        env.set("org.kie.api.persistence.jpa.EntityManagerFactory", ctx.getBean("myEmf"));
        env.set("org.kie.transaction.TransactionManager", ctx.getBean("txManager"));
        KieStoreServices kstore = (KieStoreServices)ctx.getBean("kstore1");
        KieBase kbase1 = (KieBase)ctx.getBean("kb_persistence");
        service = kstore.loadKieSession(Long.valueOf(sessionId), kbase1, null, env);
        processInstance = service.getProcessInstance(processInstance.getId());
        Assert.assertNotNull((Object)processInstance);
        service.dispose();
        service = kstore.loadKieSession(Long.valueOf(sessionId), kbase1, null, env);
        service.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        workItem = handler.getWorkItem();
        Assert.assertNotNull((Object)workItem);
        service.dispose();
        service = kstore.loadKieSession(Long.valueOf(sessionId), kbase1, null, env);
        processInstance = service.getProcessInstance(processInstance.getId());
        Assert.assertNotNull((Object)processInstance);
        service.dispose();
        service = kstore.loadKieSession(Long.valueOf(sessionId), kbase1, null, env);
        service.getWorkItemManager().abortWorkItem(workItem.getId());
        workItem = handler.getWorkItem();
        Assert.assertNotNull((Object)workItem);
        service.dispose();
        service = kstore.loadKieSession(Long.valueOf(sessionId), kbase1, null, env);
        processInstance = service.getProcessInstance(processInstance.getId());
        Assert.assertNotNull((Object)processInstance);
        service.dispose();
        service = kstore.loadKieSession(Long.valueOf(sessionId), kbase1, null, env);
        service.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        workItem = handler.getWorkItem();
        Assert.assertNull((Object)workItem);
        service.dispose();
        service = kstore.loadKieSession(Long.valueOf(sessionId), kbase1, null, env);
        processInstance = service.getProcessInstance(processInstance.getId());
        Assert.assertNull((Object)processInstance);
        service.dispose();
    }

    private static KiePackage getProcessWorkItems() {
        RuleFlowProcess process = new RuleFlowProcess();
        process.setId("org.drools.test.TestProcess");
        process.setName("TestProcess");
        process.setPackageName("org.drools.test");
        StartNode start = new StartNode();
        start.setId(1L);
        start.setName("Start");
        process.addNode((Node)start);
        ActionNode actionNode = new ActionNode();
        actionNode.setId(2L);
        actionNode.setName("Action");
        DroolsConsequenceAction action = new DroolsConsequenceAction();
        action.setDialect("java");
        action.setConsequence("System.out.println(\"Executed action\");");
        actionNode.setAction((DroolsAction)action);
        process.addNode((Node)actionNode);
        new ConnectionImpl((Node)start, "DROOLS_DEFAULT", (Node)actionNode, "DROOLS_DEFAULT");
        WorkItemNode workItemNode = new WorkItemNode();
        workItemNode.setId(3L);
        workItemNode.setName("WorkItem1");
        WorkImpl work = new WorkImpl();
        work.setName("MyWork");
        workItemNode.setWork((Work)work);
        process.addNode((Node)workItemNode);
        new ConnectionImpl((Node)actionNode, "DROOLS_DEFAULT", (Node)workItemNode, "DROOLS_DEFAULT");
        WorkItemNode workItemNode2 = new WorkItemNode();
        workItemNode2.setId(4L);
        workItemNode2.setName("WorkItem2");
        work = new WorkImpl();
        work.setName("MyWork");
        workItemNode2.setWork((Work)work);
        process.addNode((Node)workItemNode2);
        new ConnectionImpl((Node)workItemNode, "DROOLS_DEFAULT", (Node)workItemNode2, "DROOLS_DEFAULT");
        WorkItemNode workItemNode3 = new WorkItemNode();
        workItemNode3.setId(5L);
        workItemNode3.setName("WorkItem3");
        work = new WorkImpl();
        work.setName("MyWork");
        workItemNode3.setWork((Work)work);
        process.addNode((Node)workItemNode3);
        new ConnectionImpl((Node)workItemNode2, "DROOLS_DEFAULT", (Node)workItemNode3, "DROOLS_DEFAULT");
        EndNode end = new EndNode();
        end.setId(6L);
        end.setName("End");
        process.addNode((Node)end);
        new ConnectionImpl((Node)workItemNode3, "DROOLS_DEFAULT", (Node)end, "DROOLS_DEFAULT");
        KnowledgeBuilderImpl packageBuilder = new KnowledgeBuilderImpl();
        ProcessBuilderImpl processBuilder = new ProcessBuilderImpl(packageBuilder);
        processBuilder.buildProcess((Process)process, null);
        return packageBuilder.getPackage();
    }

    public static void writePackage(KiePackage pkg, File dest) {
        dest.deleteOnExit();
        OutputStream out = null;
        try {
            out = new BufferedOutputStream(new FileOutputStream(dest));
            DroolsStreamUtils.streamOut((OutputStream)out, (Object)pkg);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Test
    public void testPersistenceSubProcess() {
        KieBase kbase = (KieBase)ctx.getBean("kb_persistence");
        KieSession service = (KieSession)ctx.getBean("jpaSingleSessionCommandService");
        long sessionId = service.getIdentifier();
        RuleFlowProcessInstance processInstance = (RuleFlowProcessInstance)service.startProcess("org.drools.test.ProcessSubProcess");
        log.debug("Started process instance {}", (Object)processInstance.getId());
        long processInstanceId = processInstance.getId();
        TestWorkItemHandler handler = TestWorkItemHandler.getInstance();
        WorkItem workItem = handler.getWorkItem();
        Assert.assertNotNull((Object)workItem);
        service.dispose();
        Environment env = KieServices.get().newEnvironment();
        env.set("org.kie.api.persistence.jpa.EntityManagerFactory", ctx.getBean("myEmf"));
        env.set("org.kie.transaction.TransactionManager", ctx.getBean("txManager"));
        KieStoreServices kstore = (KieStoreServices)ctx.getBean("kstore1");
        KieBase kbase1 = (KieBase)ctx.getBean("kb_persistence");
        service = kstore.loadKieSession(Long.valueOf(sessionId), kbase1, null, env);
        processInstance = (RuleFlowProcessInstance)service.getProcessInstance(processInstanceId);
        Assert.assertNotNull((Object)processInstance);
        Collection nodeInstances = processInstance.getNodeInstances();
        Assert.assertEquals((long)1L, (long)nodeInstances.size());
        SubProcessNodeInstance subProcessNodeInstance = (SubProcessNodeInstance)nodeInstances.iterator().next();
        long subProcessInstanceId = subProcessNodeInstance.getProcessInstanceId();
        RuleFlowProcessInstance subProcessInstance = (RuleFlowProcessInstance)service.getProcessInstance(subProcessInstanceId);
        Assert.assertNotNull((Object)subProcessInstance);
        service.dispose();
        service = kstore.loadKieSession(Long.valueOf(sessionId), kbase1, null, env);
        service.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        service.dispose();
        service = kstore.loadKieSession(Long.valueOf(sessionId), kbase1, null, env);
        subProcessInstance = (RuleFlowProcessInstance)service.getProcessInstance(subProcessInstanceId);
        Assert.assertNull((Object)subProcessInstance);
        processInstance = (RuleFlowProcessInstance)service.getProcessInstance(processInstanceId);
        Assert.assertNull((Object)processInstance);
        service.dispose();
    }

    @Test
    public void testPersistenceSubProcessWithListeners() {
        KieBase kbase = (KieBase)ctx.getBean("kb_persistence");
        KieSession service = (KieSession)ctx.getBean("jpaSingleSessionCommandServiceWithListeners");
        long sessionId = service.getIdentifier();
        Collection listenersP = service.getProcessEventListeners();
        Assert.assertEquals((long)1L, (long)listenersP.size());
        Collection listenersA = service.getAgendaEventListeners();
        Assert.assertEquals((long)3L, (long)listenersA.size());
        Collection listenersR = service.getRuleRuntimeEventListeners();
        Assert.assertEquals((long)1L, (long)listenersR.size());
        RuleFlowProcessInstance processInstance = (RuleFlowProcessInstance)service.startProcess("org.drools.test.ProcessSubProcess");
        log.debug("Started process instance {}", (Object)processInstance.getId());
        long processInstanceId = processInstance.getId();
        TestWorkItemHandler handler = TestWorkItemHandler.getInstance();
        WorkItem workItem = handler.getWorkItem();
        Assert.assertNotNull((Object)workItem);
        service.dispose();
        Environment env = KieServices.get().newEnvironment();
        env.set("org.kie.api.persistence.jpa.EntityManagerFactory", ctx.getBean("myEmf"));
        env.set("org.kie.transaction.TransactionManager", ctx.getBean("txManager"));
        KieStoreServices kstore = (KieStoreServices)ctx.getBean("kstore1");
        KieBase kbase1 = (KieBase)ctx.getBean("kb_persistence");
        service = kstore.loadKieSession(Long.valueOf(sessionId), kbase1, null, env);
        processInstance = (RuleFlowProcessInstance)service.getProcessInstance(processInstanceId);
        Assert.assertNotNull((Object)processInstance);
        Collection nodeInstances = processInstance.getNodeInstances();
        Assert.assertEquals((long)1L, (long)nodeInstances.size());
        SubProcessNodeInstance subProcessNodeInstance = (SubProcessNodeInstance)nodeInstances.iterator().next();
        long subProcessInstanceId = subProcessNodeInstance.getProcessInstanceId();
        RuleFlowProcessInstance subProcessInstance = (RuleFlowProcessInstance)service.getProcessInstance(subProcessInstanceId);
        Assert.assertNotNull((Object)subProcessInstance);
        service.dispose();
        service = kstore.loadKieSession(Long.valueOf(sessionId), kbase1, null, env);
        service.getWorkItemManager().completeWorkItem(workItem.getId(), null);
        service.dispose();
        service = kstore.loadKieSession(Long.valueOf(sessionId), kbase1, null, env);
        subProcessInstance = (RuleFlowProcessInstance)service.getProcessInstance(subProcessInstanceId);
        Assert.assertNull((Object)subProcessInstance);
        processInstance = (RuleFlowProcessInstance)service.getProcessInstance(processInstanceId);
        Assert.assertNull((Object)processInstance);
        service.dispose();
    }

    private static KiePackage getProcessSubProcess() {
        RuleFlowProcess process = new RuleFlowProcess();
        process.setId("org.drools.test.ProcessSubProcess");
        process.setName("ProcessSubProcess");
        process.setPackageName("org.drools.test");
        StartNode start = new StartNode();
        start.setId(1L);
        start.setName("Start");
        process.addNode((Node)start);
        ActionNode actionNode = new ActionNode();
        actionNode.setId(2L);
        actionNode.setName("Action");
        DroolsConsequenceAction action = new DroolsConsequenceAction();
        action.setDialect("java");
        action.setConsequence("System.out.println(\"Executed action\");");
        actionNode.setAction((DroolsAction)action);
        process.addNode((Node)actionNode);
        new ConnectionImpl((Node)start, "DROOLS_DEFAULT", (Node)actionNode, "DROOLS_DEFAULT");
        SubProcessNode subProcessNode = new SubProcessNode();
        subProcessNode.setId(3L);
        subProcessNode.setName("SubProcess");
        subProcessNode.setProcessId("org.drools.test.SubProcess");
        process.addNode((Node)subProcessNode);
        new ConnectionImpl((Node)actionNode, "DROOLS_DEFAULT", (Node)subProcessNode, "DROOLS_DEFAULT");
        EndNode end = new EndNode();
        end.setId(4L);
        end.setName("End");
        process.addNode((Node)end);
        new ConnectionImpl((Node)subProcessNode, "DROOLS_DEFAULT", (Node)end, "DROOLS_DEFAULT");
        KnowledgeBuilderImpl packageBuilder = new KnowledgeBuilderImpl();
        ProcessBuilderImpl processBuilder = new ProcessBuilderImpl(packageBuilder);
        processBuilder.buildProcess((Process)process, null);
        process = new RuleFlowProcess();
        process.setId("org.drools.test.SubProcess");
        process.setName("SubProcess");
        process.setPackageName("org.drools.test");
        start = new StartNode();
        start.setId(1L);
        start.setName("Start");
        process.addNode((Node)start);
        actionNode = new ActionNode();
        actionNode.setId(2L);
        actionNode.setName("Action");
        action = new DroolsConsequenceAction();
        action.setDialect("java");
        action.setConsequence("System.out.println(\"Executed action\");");
        actionNode.setAction((DroolsAction)action);
        process.addNode((Node)actionNode);
        new ConnectionImpl((Node)start, "DROOLS_DEFAULT", (Node)actionNode, "DROOLS_DEFAULT");
        WorkItemNode workItemNode = new WorkItemNode();
        workItemNode.setId(3L);
        workItemNode.setName("WorkItem1");
        WorkImpl work = new WorkImpl();
        work.setName("MyWork");
        workItemNode.setWork((Work)work);
        process.addNode((Node)workItemNode);
        new ConnectionImpl((Node)actionNode, "DROOLS_DEFAULT", (Node)workItemNode, "DROOLS_DEFAULT");
        end = new EndNode();
        end.setId(6L);
        end.setName("End");
        process.addNode((Node)end);
        new ConnectionImpl((Node)workItemNode, "DROOLS_DEFAULT", (Node)end, "DROOLS_DEFAULT");
        processBuilder.buildProcess((Process)process, null);
        return packageBuilder.getPackage();
    }

    @Test
    @Ignore(value="Test causes occational deadlock in service.getProcessInstance(procId)")
    public void testPersistenceTimer() throws Exception {
        log.debug("---> get bean jpaSingleSessionCommandService");
        KieSession service = (KieSession)ctx.getBean("jpaSingleSessionCommandService");
        long sessionId = service.getIdentifier();
        log.debug("---> created SingleSessionCommandService id: " + sessionId);
        ProcessInstance processInstance = service.startProcess("org.drools.test.ProcessTimer");
        long procId = processInstance.getId();
        log.debug("---> Started ProcessTimer id: {}", (Object)procId);
        service.dispose();
        log.debug("---> session disposed");
        Environment env = KieServices.get().newEnvironment();
        env.set("org.kie.api.persistence.jpa.EntityManagerFactory", ctx.getBean("myEmf"));
        env.set("org.kie.transaction.TransactionManager", ctx.getBean("txManager"));
        KieStoreServices kstore = (KieStoreServices)ctx.getBean("kstore1");
        KieBase kbase1 = (KieBase)ctx.getBean("kb_persistence");
        service = kstore.loadKieSession(Long.valueOf(sessionId), kbase1, null, env);
        log.debug("---> load session: " + sessionId);
        processInstance = service.getProcessInstance(procId);
        log.debug("---> GetProcessInstanceCommand id: " + procId);
        Assert.assertNotNull((Object)processInstance);
        JPASingleSessionCommandServiceFactoryTest.waitForTimer();
        log.debug("---> session disposed");
        service.dispose();
        service = kstore.loadKieSession(Long.valueOf(sessionId), kbase1, null, env);
        log.debug("---> load session: " + sessionId);
        Thread.sleep(500L);
        log.debug("---> GetProcessInstanceCommand id: " + procId);
        processInstance = service.getProcessInstance(procId);
        log.debug("---> session disposed");
        Assert.assertNull((Object)processInstance);
    }

    private static KiePackage getProcessTimer() {
        RuleFlowProcess process = new RuleFlowProcess();
        process.setId("org.drools.test.ProcessTimer");
        process.setName("ProcessTimer");
        process.setPackageName("org.drools.test");
        StartNode start = new StartNode();
        start.setId(1L);
        start.setName("Start");
        process.addNode((Node)start);
        TimerNode timerNode = new TimerNode();
        timerNode.setId(2L);
        timerNode.setName("Timer");
        Timer timer = new Timer();
        timer.setDelay("750");
        timerNode.setTimer(timer);
        process.addNode((Node)timerNode);
        new ConnectionImpl((Node)start, "DROOLS_DEFAULT", (Node)timerNode, "DROOLS_DEFAULT");
        ActionNode actionNode = new ActionNode();
        actionNode.setId(3L);
        actionNode.setName("Action");
        DroolsConsequenceAction action = new DroolsConsequenceAction();
        action.setDialect("java");
        action.setConsequence("try {  org.kie.spring.tests.persistence.JPASingleSessionCommandServiceFactoryTest.waitForTest(); } catch (Throwable t) { t.printStackTrace(); } System.out.println(\"Executed timer action\");");
        actionNode.setAction((DroolsAction)action);
        process.addNode((Node)actionNode);
        new ConnectionImpl((Node)timerNode, "DROOLS_DEFAULT", (Node)actionNode, "DROOLS_DEFAULT");
        EndNode end = new EndNode();
        end.setId(6L);
        end.setName("End");
        process.addNode((Node)end);
        new ConnectionImpl((Node)actionNode, "DROOLS_DEFAULT", (Node)end, "DROOLS_DEFAULT");
        KnowledgeBuilderImpl packageBuilder = new KnowledgeBuilderImpl();
        ProcessBuilderImpl processBuilder = new ProcessBuilderImpl(packageBuilder);
        processBuilder.buildProcess((Process)process, null);
        return packageBuilder.getPackage();
    }

    @Test
    public void testPersistenceTimer2() throws Exception {
        KieBase kBase = (KieBase)ctx.getBean("kb_persistence");
        KieSession service = (KieSession)ctx.getBean("jpaSingleSessionCommandService");
        long sessionId = service.getIdentifier();
        ProcessInstance processInstance = service.startProcess("org.drools.test.ProcessTimer2");
        log.debug("Started process instance {}", (Object)processInstance.getId());
        JPASingleSessionCommandServiceFactoryTest.waitForTimer();
        Thread.sleep(500L);
        Environment env = KieServices.get().newEnvironment();
        env.set("org.kie.api.persistence.jpa.EntityManagerFactory", ctx.getBean("myEmf"));
        env.set("org.kie.transaction.TransactionManager", ctx.getBean("txManager"));
        KieStoreServices kstore = (KieStoreServices)ctx.getBean("kstore1");
        KieBase kbase1 = (KieBase)ctx.getBean("kb_persistence");
        service = kstore.loadKieSession(Long.valueOf(sessionId), kbase1, null, env);
        processInstance = service.getProcessInstance(processInstance.getId());
        Assert.assertNull((Object)processInstance);
    }

    private static KiePackage getProcessTimer2() {
        RuleFlowProcess process = new RuleFlowProcess();
        process.setId("org.drools.test.ProcessTimer2");
        process.setName("ProcessTimer2");
        process.setPackageName("org.drools.test");
        StartNode start = new StartNode();
        start.setId(1L);
        start.setName("Start");
        process.addNode((Node)start);
        TimerNode timerNode = new TimerNode();
        timerNode.setId(2L);
        timerNode.setName("Timer");
        Timer timer = new Timer();
        timer.setDelay("0");
        timerNode.setTimer(timer);
        process.addNode((Node)timerNode);
        new ConnectionImpl((Node)start, "DROOLS_DEFAULT", (Node)timerNode, "DROOLS_DEFAULT");
        ActionNode actionNode = new ActionNode();
        actionNode.setId(3L);
        actionNode.setName("Action");
        DroolsConsequenceAction action = new DroolsConsequenceAction();
        action.setDialect("java");
        action.setConsequence("try {  org.kie.spring.tests.persistence.JPASingleSessionCommandServiceFactoryTest.waitForTest(); } catch (Throwable t) { t.printStackTrace(); } System.out.println(\"Executed timer action\");");
        actionNode.setAction((DroolsAction)action);
        process.addNode((Node)actionNode);
        new ConnectionImpl((Node)timerNode, "DROOLS_DEFAULT", (Node)actionNode, "DROOLS_DEFAULT");
        EndNode end = new EndNode();
        end.setId(6L);
        end.setName("End");
        process.addNode((Node)end);
        new ConnectionImpl((Node)actionNode, "DROOLS_DEFAULT", (Node)end, "DROOLS_DEFAULT");
        KnowledgeBuilderImpl packageBuilder = new KnowledgeBuilderImpl();
        ProcessBuilderImpl processBuilder = new ProcessBuilderImpl(packageBuilder);
        processBuilder.buildProcess((Process)process, null);
        return packageBuilder.getPackage();
    }

    public static void waitForTest() {
        try {
            cyclicBarrier.await();
        }
        catch (InterruptedException interruptedException) {
        }
        catch (BrokenBarrierException bbe) {
            throw new IllegalStateException("The barrier is broken!", bbe);
        }
    }

    public static void waitForTimer() {
        try {
            cyclicBarrier.await();
        }
        catch (InterruptedException interruptedException) {
        }
        catch (BrokenBarrierException bbe) {
            throw new IllegalStateException("The barrier is broken!", bbe);
        }
    }

    static {
        cyclicBarrier = new CyclicBarrier(2);
    }
}

