/*
 * Decompiled with CFR 0.152.
 */
package org.kie.spring;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractUrlAssert;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.kie.spring.KModuleBeanFactoryPostProcessor;

public class KModuleBeanFactoryPostProcessorTest {
    @Test
    public void testEapContextDetectionEnumWithExpectedUrl() throws Exception {
        KModuleBeanFactoryPostProcessor postProcessor = new KModuleBeanFactoryPostProcessor();
        boolean result = postProcessor.isEapSpecificUrl(new URL("file://with-eap-specific-suffix/service-loader-resources/"));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)result).as("EAP-specific URL should have been found!", new Object[0])).isTrue();
    }

    @Test
    public void testEapContextDetectionEnumWithoutExpectedUrl() throws Exception {
        KModuleBeanFactoryPostProcessor postProcessor = new KModuleBeanFactoryPostProcessor();
        boolean result = postProcessor.isEapSpecificUrl(new URL("file://my-test-url/no-eap-specific-context"));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)result).as("EAP-specific URL should _not_ have been found!", new Object[0])).isFalse();
    }

    @Test
    public void testTryGetRootUrlForEapContext() throws Exception {
        final URL webInfClassesUrl = new URL("file://war-urls/WEB-INF/classes/");
        Enumeration<URL> urls = new Enumeration<URL>(){
            private int index = 0;

            @Override
            public boolean hasMoreElements() {
                return this.index <= 1;
            }

            @Override
            public URL nextElement() {
                try {
                    if (this.index == 0) {
                        ++this.index;
                        return webInfClassesUrl;
                    }
                    if (this.index == 1) {
                        ++this.index;
                        return new URL("file://some-path-with-eap-specific-suffix/service-loader-resources/");
                    }
                    throw new IllegalStateException("");
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException("Buggy test!", e);
                }
            }
        };
        KModuleBeanFactoryPostProcessor postProcessor = new KModuleBeanFactoryPostProcessor();
        URL actualUrl = postProcessor.tryGetRootUrlForEapContext((Enumeration)urls);
        ((AbstractUrlAssert)Assertions.assertThat((URL)actualUrl).as("KModule root URL should have been found inside enumeration " + urls + "!", new Object[0])).isEqualTo((Object)webInfClassesUrl);
    }
}

