/*
 * Decompiled with CFR 0.152.
 */
package org.kie.spring.jbpm;

import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.spring.jbpm.AbstractJbpmSpringTest;
import org.kie.spring.jbpm.tools.RuntimeManagerHolder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(value={"classpath:jbpm/multiple-runtime-managers/local-emf-singleton.xml"})
@DirtiesContext
public class MultipleRuntimeManagersTest
extends AbstractJbpmSpringTest {
    @Autowired
    private ApplicationContext context;
    @Autowired
    @Qualifier(value="holderOne")
    private RuntimeManagerHolder holderOne;
    @Autowired
    @Qualifier(value="holderTwo")
    private RuntimeManagerHolder holderTwo;
    private static final String RUNTIME_MANAGER_ONE = "runtimeManager";
    private static final String RUNTIME_MANAGER_TWO = "runtimeManagerTwo";

    @Test
    public void testGettingMultipleRuntimeManagersByInjection() throws Exception {
        Assert.assertNotEquals((Object)this.holderOne, (Object)this.holderTwo);
        Assert.assertEquals((Object)this.holderOne.getRuntimeManager(), (Object)this.holderTwo.getRuntimeManager());
    }

    @Test
    public void testGettingMultipleRuntimeManagersByContextRetrieve() throws Exception {
        RuntimeManager managerOne = (RuntimeManager)this.context.getBean(RUNTIME_MANAGER_ONE, RuntimeManager.class);
        RuntimeManager managerTwo = (RuntimeManager)this.context.getBean(RUNTIME_MANAGER_TWO, RuntimeManager.class);
        Assert.assertEquals((Object)managerOne, (Object)managerTwo);
    }
}

