/*
 * Decompiled with CFR 0.152.
 */
package org.kie.spring.tests;

import org.drools.core.time.SessionPseudoClock;
import org.drools.core.time.impl.JDKTimerService;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.conf.ClockTypeOption;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class KieSpringKieSessionAttributesTest {
    private static AbstractApplicationContext context = null;

    @BeforeClass
    public static void setup() {
        context = new ClassPathXmlApplicationContext("org/kie/spring/kiesession-attributes.xml");
    }

    @Test
    public void testContext() throws Exception {
        Assert.assertNotNull((Object)context);
    }

    @Test
    public void testStatefulRealTimeClockKieSession() throws Exception {
        KieSession ksession = (KieSession)context.getBean("statefulSessionRealTime", KieSession.class);
        Assert.assertNotNull((Object)ksession);
        Assert.assertEquals((String)"Session has configured different clock type", (Object)ClockTypeOption.get((String)"realtime"), (Object)ksession.getSessionConfiguration().getOption(ClockTypeOption.class));
        Assert.assertTrue((String)String.format("Session clock not an instance of '~s', but: '~s'.", JDKTimerService.class.getSimpleName(), ksession.getSessionClock().getClass().getSimpleName()), (boolean)(ksession.getSessionClock() instanceof JDKTimerService));
    }

    @Test
    public void testStatefulPseudoClockKieSession() throws Exception {
        KieSession ksession = (KieSession)context.getBean("statefulSessionPseudo", KieSession.class);
        Assert.assertNotNull((Object)ksession);
        Assert.assertEquals((String)"Session has configured different clock type", (Object)ClockTypeOption.get((String)"pseudo"), (Object)ksession.getSessionConfiguration().getOption(ClockTypeOption.class));
        Assert.assertTrue((String)String.format("Session clock not an instance of '~s', but '~s'.", SessionPseudoClock.class.getSimpleName(), ksession.getSessionClock().getClass().getSimpleName()), (boolean)(ksession.getSessionClock() instanceof SessionPseudoClock));
    }

    @AfterClass
    public static void tearDown() {
        context.destroy();
    }
}

