/*
 * Decompiled with CFR 0.152.
 */
package org.kie.spring.timer;

import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.drools.core.base.MapGlobalResolver;
import org.junit.Assert;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.persistence.jpa.KieStoreServices;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.spring.timer.TestWorkItemHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.orm.jpa.JpaTransactionManager;

public class MyDroolsBean {
    private static AtomicInteger timerTriggerCount = new AtomicInteger();
    private static long sessionId;
    private static Logger logger;
    private EntityManagerFactory emf;
    private KieBase kbase;
    private KieStoreServices kstore;
    private JpaTransactionManager txm;
    private TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
    private static CyclicBarrier cyclicBarrier;

    public void initStartDisposeAndLoadSession() {
        try {
            EntityManager em = this.txm.getEntityManagerFactory().createEntityManager();
            KieSession ksession = this.kstore.newKieSession(this.kbase, null, this.getEnvironment());
            sessionId = ksession.getIdentifier();
            logger.debug("\n\tSession id: " + sessionId + "\n");
            ksession.getWorkItemManager().registerWorkItemHandler("testWorkItemHandler", (WorkItemHandler)this.workItemHandler);
            ksession.startProcess("timer-flow", null);
            MyDroolsBean.waitForOtherThread();
            ksession.dispose();
        }
        catch (Exception ex) {
            throw new IllegalStateException("The endTheProcess method has been interrupted", ex);
        }
    }

    public static void waitForOtherThread() {
        try {
            cyclicBarrier.await();
        }
        catch (InterruptedException interruptedException) {
        }
        catch (BrokenBarrierException bbe) {
            logger.error("cyclic barrier has a broken state!", (Throwable)bbe);
        }
    }

    public static void incrementTimerTriggerCount() {
        timerTriggerCount.incrementAndGet();
    }

    public static int getTimerTriggerCount() {
        return timerTriggerCount.get();
    }

    public void endTheProcess() {
        try {
            KieSession ksession = this.kstore.loadKieSession(Long.valueOf(sessionId), this.kbase, null, this.getEnvironment());
            logger.debug("\n\nSleeping to check that the timer is still running");
            try {
                cyclicBarrier.await(3L, TimeUnit.SECONDS);
            }
            catch (BrokenBarrierException brokenBarrierException) {
            }
            catch (TimeoutException timeoutException) {
                // empty catch block
            }
            ksession.getWorkItemManager().completeWorkItem(TestWorkItemHandler.getWorkItem().getId(), null);
            logger.debug("\n\nSleeping to check that the timer is no longer running");
            boolean waitFailed = false;
            try {
                cyclicBarrier.await(3L, TimeUnit.SECONDS);
                Assert.fail((String)"The timer should not have been running!");
            }
            catch (BrokenBarrierException bbe) {
                Assert.fail((String)("The barrier should not be broken: " + bbe.getMessage()));
            }
            catch (TimeoutException e) {
                waitFailed = true;
            }
            Assert.assertTrue((boolean)waitFailed);
            logger.debug("Ok");
            ksession.dispose();
        }
        catch (InterruptedException ex) {
            throw new IllegalStateException("The endTheProcess method has been interrupted", ex);
        }
    }

    private Environment getEnvironment() {
        Environment environment = KieServices.get().newEnvironment();
        environment.set("org.kie.api.persistence.jpa.EntityManagerFactory", (Object)this.emf);
        environment.set("org.kie.transaction.TransactionManager", (Object)this.txm);
        environment.set("org.kie.Globals", (Object)new MapGlobalResolver());
        return environment;
    }

    public void setEmf(EntityManagerFactory emf) {
        this.emf = emf;
    }

    public void setKbase(KieBase kbase) {
        this.kbase = kbase;
    }

    public void setKstore(KieStoreServices kstore) {
        this.kstore = kstore;
    }

    public void setTxm(JpaTransactionManager txm) {
        this.txm = txm;
    }

    static {
        logger = LoggerFactory.getLogger(MyDroolsBean.class);
        cyclicBarrier = new CyclicBarrier(2);
    }
}

