/*
 * Decompiled with CFR 0.152.
 */
package org.kie.spring.tests;

import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kie.api.event.rule.RuleRuntimeEventListener;
import org.kie.api.runtime.KieSession;
import org.kie.spring.beans.Person;
import org.kie.spring.mocks.MockIncrementingRuleRuntimeEventListener;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.test.util.AssertionErrors;

public class KieSpringListenersBatchTest {
    static ApplicationContext context = null;
    List<Person> list = new ArrayList<Person>();

    @BeforeClass
    public static void runBeforeClass() {
        context = new ClassPathXmlApplicationContext("org/kie/spring/listeners-with-batch.xml");
    }

    @Before
    public void clearGlobalList() {
        this.list.clear();
    }

    @Test
    public void testStatefulWMEventListener() throws Exception {
        KieSession kSession = (KieSession)context.getBean("ksession1");
        Assert.assertTrue((kSession.getRuleRuntimeEventListeners().size() > 0 ? 1 : 0) != 0);
        MockIncrementingRuleRuntimeEventListener listener = this.findMockIncrementingRuleRuntimeEventListener(kSession);
        AssertionErrors.assertEquals((String)"Counter incremented unexpected number of times.", (Object)1, (Object)listener.getCounter());
    }

    private MockIncrementingRuleRuntimeEventListener findMockIncrementingRuleRuntimeEventListener(KieSession kieSession) {
        for (RuleRuntimeEventListener listener : kieSession.getRuleRuntimeEventListeners()) {
            if (!(listener instanceof MockIncrementingRuleRuntimeEventListener)) continue;
            return (MockIncrementingRuleRuntimeEventListener)listener;
        }
        throw new IllegalArgumentException("Given KieSession has attached no listeners of type: " + MockIncrementingRuleRuntimeEventListener.class.getName());
    }
}

